/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hive;

import java.sql.Connection;
import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.hive.HiveClient;
import org.springframework.data.hadoop.hive.HiveClientFactory;
import org.springframework.data.hadoop.hive.HiveScript;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.util.Assert;

public class HiveClientFactoryBean
implements FactoryBean<HiveClientFactory>,
InitializingBean,
DisposableBean {
    private Collection<HiveScript> scripts;
    private DataSource hiveDataSource;
    private SingleConnectionDataSource factoryDataSource;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.hiveDataSource, (String)"HiveDataSource must be set");
        Connection con = DataSourceUtils.getConnection((DataSource)this.hiveDataSource);
        this.factoryDataSource = new SingleConnectionDataSource(con, true);
    }

    public void destroy() throws Exception {
        this.factoryDataSource.destroy();
    }

    public HiveClientFactory getObject() {
        return new DefaultHiveClientFactory();
    }

    public Class<?> getObjectType() {
        return HiveClientFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected HiveClient createHiveClient() {
        if (this.factoryDataSource == null) {
            throw new IllegalStateException("HiveDataSource must be set before requesting a HiveClient");
        }
        return new HiveClient((DataSource)this.factoryDataSource);
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public void setHiveDataSource(DataSource dataSource) {
        this.hiveDataSource = dataSource;
    }

    public void setScripts(Collection<HiveScript> scripts) {
        this.scripts = scripts;
    }

    private class DefaultHiveClientFactory
    implements HiveClientFactory {
        private DefaultHiveClientFactory() {
        }

        @Override
        public HiveClient getHiveClient() throws BeansException {
            try {
                return HiveClientFactoryBean.this.createHiveClient();
            }
            catch (Exception ex) {
                throw new BeanCreationException("Cannot create HiveClient instance", (Throwable)ex);
            }
        }
    }
}

