/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.pig;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.ExecType;
import org.apache.pig.impl.PigContext;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class PigContextFactoryBean
implements InitializingBean,
FactoryBean<PigContext> {
    private PigContext context;
    private String lastAlias;
    private String jobTracker;
    private ExecType execType = ExecType.MAPREDUCE;
    private Properties properties;
    private Configuration configuration;

    public PigContext getObject() throws Exception {
        return this.context;
    }

    public Class<?> getObjectType() {
        return this.context != null ? this.context.getClass() : PigContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Properties prop = new Properties();
        if (this.configuration != null) {
            for (Map.Entry entry : this.configuration) {
                prop.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.properties != null) {
            Enumeration<?> names = this.properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                prop.setProperty(name, this.properties.getProperty(name));
            }
        }
        if (StringUtils.hasText((String)this.jobTracker)) {
            prop.setProperty("mapred.job.tracker", this.jobTracker);
        }
        this.context = new PigContext(this.execType, prop);
        if (StringUtils.hasText((String)this.lastAlias)) {
            this.context.setLastAlias(this.lastAlias);
        }
    }

    public void setLastAlias(String lastAlias) {
        this.lastAlias = lastAlias;
    }

    public void setJobTracker(String jobTracker) {
        this.jobTracker = jobTracker;
    }

    public void setExecType(ExecType execType) {
        this.execType = execType;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

