/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Arrays;

public final class EscapeCharacter {
    private final char escapeCharacter;

    public String escape(String value) {
        if (value == null) {
            return null;
        }
        String result = value;
        for (String toReplace : Arrays.asList(String.valueOf(this.escapeCharacter), "_", "%")) {
            result = result.replace(toReplace, this.escapeCharacter + toReplace);
        }
        return result;
    }

    private EscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public static EscapeCharacter of(char escapeCharacter) {
        return new EscapeCharacter(escapeCharacter);
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EscapeCharacter)) {
            return false;
        }
        EscapeCharacter other = (EscapeCharacter)o;
        return this.getEscapeCharacter() == other.getEscapeCharacter();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEscapeCharacter();
        return result;
    }

    public String toString() {
        return "EscapeCharacter(escapeCharacter=" + this.getEscapeCharacter() + ")";
    }
}

