/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JSqlParserUtils;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JSqlParserQueryEnhancer
implements QueryEnhancer {
    private final DeclaredQuery query;
    private final ParsedType parsedType;

    public JSqlParserQueryEnhancer(DeclaredQuery query) {
        this.query = query;
        this.parsedType = this.detectParsedType();
    }

    private ParsedType detectParsedType() {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)this.query.getQueryString());
            if (statement instanceof Update) {
                return ParsedType.UPDATE;
            }
            if (statement instanceof Delete) {
                return ParsedType.DELETE;
            }
            if (statement instanceof Select) {
                return ParsedType.SELECT;
            }
            return ParsedType.SELECT;
        }
        catch (JSQLParserException e) {
            throw new IllegalArgumentException("The query you provided is not a valid SQL Query!", e);
        }
    }

    @Override
    public String applySorting(Sort sort, @Nullable String alias) {
        String queryString = this.query.getQueryString();
        Assert.hasText((String)queryString, (String)"Query must not be null or empty!");
        if (this.parsedType != ParsedType.SELECT) {
            return queryString;
        }
        if (sort.isUnsorted()) {
            return queryString;
        }
        Select selectStatement = JSqlParserQueryEnhancer.parseSelectStatement(queryString);
        if (selectStatement.getSelectBody() instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectStatement.getSelectBody();
            return this.applySortingToSetOperationList(setOperationList, sort);
        }
        if (!(selectStatement.getSelectBody() instanceof PlainSelect)) {
            return queryString;
        }
        PlainSelect selectBody = (PlainSelect)selectStatement.getSelectBody();
        Set<String> joinAliases = this.getJoinAliases(selectBody);
        Set<String> selectionAliases = this.getSelectionAliases(selectBody);
        List orderByElements = sort.stream().map(order -> this.getOrderClause(joinAliases, selectionAliases, alias, (Sort.Order)order)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)selectBody.getOrderByElements())) {
            selectBody.setOrderByElements(new ArrayList());
        }
        selectBody.getOrderByElements().addAll(orderByElements);
        return selectBody.toString();
    }

    private String applySortingToSetOperationList(SetOperationList setOperationListStatement, Sort sort) {
        if (setOperationListStatement.getSelects().stream().anyMatch(ValuesStatement.class::isInstance)) {
            return setOperationListStatement.toString();
        }
        if (setOperationListStatement.getOrderByElements() == null) {
            setOperationListStatement.setOrderByElements(new ArrayList());
        }
        List orderByElements = sort.stream().map(order -> this.getOrderClause(Collections.emptySet(), Collections.emptySet(), null, (Sort.Order)order)).collect(Collectors.toList());
        setOperationListStatement.getOrderByElements().addAll(orderByElements);
        return setOperationListStatement.toString();
    }

    private Set<String> getSelectionAliases(PlainSelect selectBody) {
        if (CollectionUtils.isEmpty((Collection)selectBody.getSelectItems())) {
            return new HashSet<String>();
        }
        return selectBody.getSelectItems().stream().filter(SelectExpressionItem.class::isInstance).map(item -> ((SelectExpressionItem)item).getAlias()).filter(Objects::nonNull).map(Alias::getName).collect(Collectors.toSet());
    }

    Set<String> getSelectionAliases() {
        if (this.parsedType != ParsedType.SELECT) {
            return new HashSet<String>();
        }
        Select selectStatement = JSqlParserQueryEnhancer.parseSelectStatement(this.query.getQueryString());
        PlainSelect selectBody = (PlainSelect)selectStatement.getSelectBody();
        return this.getSelectionAliases(selectBody);
    }

    private Set<String> getJoinAliases(String query) {
        if (this.parsedType != ParsedType.SELECT) {
            return new HashSet<String>();
        }
        Select selectStatement = JSqlParserQueryEnhancer.parseSelectStatement(query);
        if (selectStatement.getSelectBody() instanceof PlainSelect) {
            PlainSelect selectBody = (PlainSelect)selectStatement.getSelectBody();
            return this.getJoinAliases(selectBody);
        }
        return new HashSet<String>();
    }

    private Set<String> getJoinAliases(PlainSelect selectBody) {
        if (CollectionUtils.isEmpty((Collection)selectBody.getJoins())) {
            return new HashSet<String>();
        }
        return selectBody.getJoins().stream().map(join -> join.getRightItem().getAlias()).filter(Objects::nonNull).map(Alias::getName).collect(Collectors.toSet());
    }

    private OrderByElement getOrderClause(Set<String> joinAliases, Set<String> selectionAliases, @Nullable String alias, Sort.Order order) {
        OrderByElement orderByElement = new OrderByElement();
        orderByElement.setAsc(order.getDirection().isAscending());
        orderByElement.setAscDescPresent(true);
        String property = order.getProperty();
        QueryUtils.checkSortExpression(order);
        if (selectionAliases.contains(property)) {
            Function orderExpression = order.isIgnoreCase() ? JSqlParserUtils.getJSqlLower(property) : new Column(property);
            orderByElement.setExpression((Expression)orderExpression);
            return orderByElement;
        }
        boolean qualifyReference = joinAliases.parallelStream().map(joinAlias -> joinAlias.concat(".")).noneMatch(property::startsWith);
        boolean functionIndicator = property.contains("(");
        String reference = qualifyReference && !functionIndicator && StringUtils.hasText((String)alias) ? String.format("%s.%s", alias, property) : property;
        Function orderExpression = order.isIgnoreCase() ? JSqlParserUtils.getJSqlLower(reference) : new Column(reference);
        orderByElement.setExpression((Expression)orderExpression);
        return orderByElement;
    }

    @Override
    public String detectAlias() {
        return this.detectAlias(this.query.getQueryString());
    }

    @Nullable
    private String detectAlias(String query) {
        if (this.parsedType != ParsedType.SELECT) {
            return null;
        }
        Select selectStatement = JSqlParserQueryEnhancer.parseSelectStatement(query);
        if (!(selectStatement.getSelectBody() instanceof PlainSelect)) {
            return null;
        }
        PlainSelect selectBody = (PlainSelect)selectStatement.getSelectBody();
        return JSqlParserQueryEnhancer.detectAlias(selectBody);
    }

    @Nullable
    private static String detectAlias(PlainSelect selectBody) {
        if (selectBody.getFromItem() == null) {
            return null;
        }
        Alias alias = selectBody.getFromItem().getAlias();
        return alias == null ? null : alias.getName();
    }

    @Override
    public String createCountQueryFor(@Nullable String countProjection) {
        if (this.parsedType != ParsedType.SELECT) {
            return this.query.getQueryString();
        }
        Assert.hasText((String)this.query.getQueryString(), (String)"OriginalQuery must not be null or empty!");
        Select selectStatement = JSqlParserQueryEnhancer.parseSelectStatement(this.query.getQueryString());
        if (!(selectStatement.getSelectBody() instanceof PlainSelect)) {
            return this.query.getQueryString();
        }
        PlainSelect selectBody = (PlainSelect)selectStatement.getSelectBody();
        selectBody.setOrderByElements(null);
        if (StringUtils.hasText((String)countProjection)) {
            Function jSqlCount = JSqlParserUtils.getJSqlCount(Collections.singletonList(countProjection), false);
            selectBody.setSelectItems(Collections.singletonList(new SelectExpressionItem((Expression)jSqlCount)));
            return selectBody.toString();
        }
        boolean distinct = selectBody.getDistinct() != null;
        selectBody.setDistinct(null);
        String tableAlias = JSqlParserQueryEnhancer.detectAlias(selectBody);
        List selectItems = selectBody.getSelectItems();
        if (this.onlyASingleColumnProjection(selectItems)) {
            SelectExpressionItem singleProjection = (SelectExpressionItem)selectItems.get(0);
            Column column = (Column)singleProjection.getExpression();
            String countProp = column.getFullyQualifiedName();
            Function jSqlCount = JSqlParserUtils.getJSqlCount(Collections.singletonList(countProp), distinct);
            selectBody.setSelectItems(Collections.singletonList(new SelectExpressionItem((Expression)jSqlCount)));
            return selectBody.toString();
        }
        String countProp = tableAlias == null ? "*" : tableAlias;
        Function jSqlCount = JSqlParserUtils.getJSqlCount(Collections.singletonList(countProp), distinct);
        selectBody.setSelectItems(Collections.singletonList(new SelectExpressionItem((Expression)jSqlCount)));
        if (CollectionUtils.isEmpty((Collection)selectStatement.getWithItemsList())) {
            return selectBody.toString();
        }
        String withStatements = selectStatement.getWithItemsList().stream().map(WithItem::toString).collect(Collectors.joining(","));
        return "with " + withStatements + "\n" + selectBody;
    }

    @Override
    public String getProjection() {
        SetOperationList setOperationList;
        if (this.parsedType != ParsedType.SELECT) {
            return "";
        }
        Assert.hasText((String)this.query.getQueryString(), (String)"Query must not be null or empty!");
        Select selectStatement = JSqlParserQueryEnhancer.parseSelectStatement(this.query.getQueryString());
        if (selectStatement.getSelectBody() instanceof ValuesStatement) {
            return "";
        }
        SelectBody selectBody = selectStatement.getSelectBody();
        if (selectStatement.getSelectBody() instanceof SetOperationList && !((selectBody = (SelectBody)(setOperationList = (SetOperationList)selectStatement.getSelectBody()).getSelects().get(0)) instanceof PlainSelect)) {
            return "";
        }
        return ((PlainSelect)selectBody).getSelectItems().stream().map(Object::toString).collect(Collectors.joining(", ")).trim();
    }

    @Override
    public Set<String> getJoinAliases() {
        return this.getJoinAliases(this.query.getQueryString());
    }

    private static Select parseSelectStatement(String query) {
        try {
            return (Select)CCJSqlParserUtil.parse((String)query);
        }
        catch (JSQLParserException e) {
            throw new IllegalArgumentException("The query you provided is not a valid SQL Query!", e);
        }
    }

    private boolean onlyASingleColumnProjection(List<SelectItem> projection) {
        return projection.size() == 1 && projection.get(0) instanceof SelectExpressionItem && ((SelectExpressionItem)projection.get(0)).getExpression() instanceof Column;
    }

    @Override
    public DeclaredQuery getQuery() {
        return this.query;
    }

    static enum ParsedType {
        DELETE,
        UPDATE,
        SELECT;

    }
}

