/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.JpaSort;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpqlQueryBuilder;
import org.springframework.data.jpa.repository.query.JpqlQueryCreator;
import org.springframework.data.jpa.repository.query.JpqlUtils;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JpaQueryCreator
extends AbstractQueryCreator<String, JpqlQueryBuilder.Predicate>
implements JpqlQueryCreator {
    private final ReturnedType returnedType;
    private final ParameterMetadataProvider provider;
    private final JpqlQueryTemplates templates;
    private final PartTree tree;
    private final EscapeCharacter escape;
    private final EntityType<?> entityType;
    private final JpqlQueryBuilder.Entity entity;
    private final Metamodel metamodel;

    public JpaQueryCreator(PartTree tree, ReturnedType type, ParameterMetadataProvider provider, JpqlQueryTemplates templates, EntityManager em) {
        super(tree);
        this.tree = tree;
        this.returnedType = type;
        this.provider = provider;
        this.templates = templates;
        this.escape = provider.getEscape();
        this.entityType = em.getMetamodel().entity(type.getDomainType());
        this.entity = JpqlQueryBuilder.entity(this.returnedType.getDomainType());
        this.metamodel = em.getMetamodel();
    }

    Bindable<?> getFrom() {
        return this.entityType;
    }

    JpqlQueryBuilder.Entity getEntity() {
        return this.entity;
    }

    @Override
    public boolean useTupleQuery() {
        return this.returnedType.needsCustomConstruction() && this.returnedType.getReturnedType().isInterface();
    }

    @Override
    public List<ParameterBinding> getBindings() {
        return this.provider.getBindings();
    }

    @Override
    public ParameterBinder getBinder() {
        return ParameterBinderFactory.createBinder(this.provider.getParameters(), this.getBindings());
    }

    protected JpqlQueryBuilder.Predicate create(Part part, Iterator<Object> iterator) {
        return this.toPredicate(part);
    }

    protected JpqlQueryBuilder.Predicate and(Part part, JpqlQueryBuilder.Predicate base, Iterator<Object> iterator) {
        return base.and(this.toPredicate(part));
    }

    protected JpqlQueryBuilder.Predicate or(JpqlQueryBuilder.Predicate base, JpqlQueryBuilder.Predicate predicate) {
        return base.or(predicate);
    }

    protected final String complete(@Nullable JpqlQueryBuilder.Predicate predicate, Sort sort) {
        JpqlQueryBuilder.AbstractJpqlQuery query = this.createQuery(predicate, sort);
        return query.render();
    }

    protected JpqlQueryBuilder.AbstractJpqlQuery createQuery(@Nullable JpqlQueryBuilder.Predicate predicate, Sort sort) {
        JpqlQueryBuilder.Select query = this.buildQuery(sort);
        if (predicate != null) {
            return query.where(predicate);
        }
        return query;
    }

    protected JpqlQueryBuilder.Select buildQuery(Sort sort) {
        JpqlQueryBuilder.Select select = this.doSelect(sort);
        if (this.tree.isDelete() || this.tree.isCountProjection()) {
            return select;
        }
        for (Sort.Order order : sort) {
            JpqlQueryBuilder.Expression expression;
            QueryUtils.checkSortExpression(order);
            try {
                expression = JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.entityType, PropertyPath.from((String)order.getProperty(), (Class)this.entityType.getJavaType()));
            }
            catch (PropertyReferenceException e) {
                JpaSort.JpaOrder jpaOrder;
                if (order instanceof JpaSort.JpaOrder && (jpaOrder = (JpaSort.JpaOrder)order).isUnsafe()) {
                    expression = JpqlQueryBuilder.expression(order.getProperty());
                }
                throw e;
            }
            if (order.isIgnoreCase()) {
                expression = JpqlQueryBuilder.function(this.templates.getIgnoreCaseOperator(), expression);
            }
            select.orderBy(JpqlQueryBuilder.orderBy(expression, order));
        }
        return select;
    }

    private JpqlQueryBuilder.Select doSelect(Sort sort) {
        JpqlQueryBuilder.SelectStep selectStep = JpqlQueryBuilder.selectFrom(this.entity);
        if (this.tree.isDelete()) {
            return selectStep.entity();
        }
        if (this.tree.isDistinct()) {
            selectStep = selectStep.distinct();
        }
        if (this.returnedType.needsCustomConstruction()) {
            Collection requiredSelection = null;
            requiredSelection = this.returnedType.getReturnedType().getPackageName().startsWith("java.util") || this.returnedType.getReturnedType().getPackageName().startsWith("jakarta.persistence") ? (Collection)this.metamodel.managedType(this.returnedType.getDomainType()).getAttributes().stream().map(Attribute::getName).collect(Collectors.toList()) : this.getRequiredSelection(sort, this.returnedType);
            ArrayList<JpqlQueryBuilder.PathExpression> paths = new ArrayList<JpqlQueryBuilder.PathExpression>(requiredSelection.size());
            for (String selection : requiredSelection) {
                paths.add(JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.entityType, PropertyPath.from((String)selection, (Class)this.returnedType.getDomainType()), true));
            }
            if (this.useTupleQuery()) {
                return selectStep.select(paths);
            }
            return selectStep.instantiate(this.returnedType.getReturnedType(), paths);
        }
        if (this.tree.isExistsProjection()) {
            if (this.entityType.hasSingleIdAttribute()) {
                SingularAttribute id = this.entityType.getId(this.entityType.getIdType().getJavaType());
                return selectStep.select(JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.entityType, PropertyPath.from((String)id.getName(), (Class)this.returnedType.getDomainType()), true));
            }
            List<JpqlQueryBuilder.PathExpression> paths = this.entityType.getIdClassAttributes().stream().map(it -> JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.entityType, PropertyPath.from((String)it.getName(), (Class)this.returnedType.getDomainType()), true)).toList();
            return selectStep.select(paths);
        }
        if (this.tree.isCountProjection()) {
            return selectStep.count();
        }
        return selectStep.entity();
    }

    Collection<String> getRequiredSelection(Sort sort, ReturnedType returnedType) {
        return returnedType.getInputProperties();
    }

    JpqlQueryBuilder.Expression placeholder(ParameterBinding binding) {
        return this.placeholder(binding.getRequiredPosition());
    }

    JpqlQueryBuilder.Expression placeholder(int position) {
        return JpqlQueryBuilder.parameter(JpqlQueryBuilder.ParameterPlaceholder.indexed(position));
    }

    private JpqlQueryBuilder.Predicate toPredicate(Part part) {
        return new PredicateBuilder(part).build();
    }

    private class PredicateBuilder {
        private final Part part;

        public PredicateBuilder(Part part) {
            Assert.notNull((Object)part, (String)"Part must not be null");
            this.part = part;
        }

        public JpqlQueryBuilder.Predicate build() {
            PropertyPath property = this.part.getProperty();
            Part.Type type = this.part.getType();
            JpqlQueryBuilder.PathExpression pas = JpqlUtils.toExpressionRecursively(JpaQueryCreator.this.metamodel, JpaQueryCreator.this.entity, JpaQueryCreator.this.entityType, property);
            JpqlQueryBuilder.WhereStep where = JpqlQueryBuilder.where(pas);
            JpqlQueryBuilder.WhereStep whereIgnoreCase = JpqlQueryBuilder.where(this.potentiallyIgnoreCase(pas));
            switch (type) {
                case BETWEEN: {
                    ParameterBinding.PartTreeParameterBinding first = JpaQueryCreator.this.provider.next(this.part);
                    ParameterBinding.PartTreeParameterBinding second = JpaQueryCreator.this.provider.next(this.part);
                    return where.between(JpaQueryCreator.this.placeholder(first), JpaQueryCreator.this.placeholder(second));
                }
                case GREATER_THAN: 
                case AFTER: {
                    return where.gt(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                }
                case GREATER_THAN_EQUAL: {
                    return where.gte(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                }
                case LESS_THAN: 
                case BEFORE: {
                    return where.lt(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                }
                case LESS_THAN_EQUAL: {
                    return where.lte(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                }
                case IS_NULL: {
                    return where.isNull();
                }
                case IS_NOT_NULL: {
                    return where.isNotNull();
                }
                case NOT_IN: {
                    return whereIgnoreCase.notIn(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part, Collection.class)));
                }
                case IN: {
                    return whereIgnoreCase.in(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part, Collection.class)));
                }
                case STARTING_WITH: 
                case ENDING_WITH: 
                case NOT_CONTAINING: 
                case CONTAINING: {
                    if (property.getLeafProperty().isCollection()) {
                        where = JpqlQueryBuilder.where(JpaQueryCreator.this.entity, property);
                        return type.equals((Object)Part.Type.NOT_CONTAINING) ? where.notMemberOf(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part))) : where.memberOf(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                    }
                }
                case NOT_LIKE: 
                case LIKE: {
                    ParameterBinding.PartTreeParameterBinding parameter = JpaQueryCreator.this.provider.next(this.part, String.class);
                    JpqlQueryBuilder.Expression parameterExpression = this.potentiallyIgnoreCase(this.part.getProperty(), JpaQueryCreator.this.placeholder(parameter));
                    String escapeChar = Character.toString(JpaQueryCreator.this.escape.getEscapeCharacter());
                    return type.equals((Object)Part.Type.NOT_LIKE) || type.equals((Object)Part.Type.NOT_CONTAINING) ? whereIgnoreCase.notLike(parameterExpression, escapeChar) : whereIgnoreCase.like(parameterExpression, escapeChar);
                }
                case TRUE: {
                    return where.isTrue();
                }
                case FALSE: {
                    return where.isFalse();
                }
                case NEGATING_SIMPLE_PROPERTY: 
                case SIMPLE_PROPERTY: {
                    ParameterBinding.PartTreeParameterBinding simple = JpaQueryCreator.this.provider.next(this.part);
                    if (simple.isIsNullParameter()) {
                        return type.equals((Object)Part.Type.SIMPLE_PROPERTY) ? where.isNull() : where.isNotNull();
                    }
                    JpqlQueryBuilder.Expression expression = this.potentiallyIgnoreCase(property, JpaQueryCreator.this.placeholder(simple));
                    return type.equals((Object)Part.Type.SIMPLE_PROPERTY) ? whereIgnoreCase.eq(expression) : whereIgnoreCase.neq(expression);
                }
                case IS_NOT_EMPTY: 
                case IS_EMPTY: {
                    if (!property.getLeafProperty().isCollection()) {
                        throw new IllegalArgumentException("IsEmpty / IsNotEmpty can only be used on collection properties");
                    }
                    where = JpqlQueryBuilder.where(JpaQueryCreator.this.entity, property);
                    return type.equals((Object)Part.Type.IS_NOT_EMPTY) ? where.isNotEmpty() : where.isEmpty();
                }
            }
            throw new IllegalArgumentException("Unsupported keyword " + String.valueOf(type));
        }

        private <T> JpqlQueryBuilder.Expression potentiallyIgnoreCase(JpqlQueryBuilder.Origin source, PropertyPath path) {
            return this.potentiallyIgnoreCase(path, JpqlQueryBuilder.expression(source, path));
        }

        private <T> JpqlQueryBuilder.Expression potentiallyIgnoreCase(JpqlQueryBuilder.PathExpression path) {
            return this.potentiallyIgnoreCase(path.getPropertyPath(), path);
        }

        private <T> JpqlQueryBuilder.Expression potentiallyIgnoreCase(PropertyPath path, JpqlQueryBuilder.Expression expressionValue) {
            switch (this.part.shouldIgnoreCase()) {
                case ALWAYS: {
                    Assert.isTrue((boolean)this.canUpperCase(path), (String)("Unable to ignore case of " + path.getType().getName() + " types, the property '" + this.part.getProperty().getSegment() + "' must reference a String"));
                    return JpqlQueryBuilder.function(JpaQueryCreator.this.templates.getIgnoreCaseOperator(), expressionValue);
                }
                case WHEN_POSSIBLE: {
                    if (!this.canUpperCase(path)) break;
                    return JpqlQueryBuilder.function(JpaQueryCreator.this.templates.getIgnoreCaseOperator(), expressionValue);
                }
            }
            return expressionValue;
        }

        private boolean canUpperCase(PropertyPath path) {
            return String.class.equals((Object)path.getType());
        }
    }
}

