/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.JpqlQueryRenderer;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.jpa.repository.query.QueryTransformers;
import org.springframework.lang.Nullable;

class JpqlCountQueryTransformer
extends JpqlQueryRenderer {
    @Nullable
    private final String countProjection;
    @Nullable
    private final String primaryFromAlias;

    JpqlCountQueryTransformer(@Nullable String countProjection, QueryInformation queryInformation) {
        this.countProjection = countProjection;
        this.primaryFromAlias = queryInformation.getAlias();
    }

    @Override
    public QueryTokenStream visitSelect_statement(JpqlParser.Select_statementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_clause()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        if (ctx.set_fuction() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.set_fuction()));
        }
        return builder;
    }

    @Override
    public QueryRenderer.QueryRendererBuilder visitSelect_clause(JpqlParser.Select_clauseContext ctx) {
        boolean usesDistinct = ctx.DISTINCT() != null;
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        builder.append(QueryTokens.TOKEN_COUNT_FUNC);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        if (this.countProjection == null) {
            if (usesDistinct) {
                nested.append(QueryTokens.expression(ctx.DISTINCT()));
                nested.append(this.getDistinctCountSelection(QueryTokenStream.concat(ctx.select_item(), arg_0 -> ((JpqlCountQueryTransformer)this).visit(arg_0), QueryTokens.TOKEN_COMMA)));
            } else {
                nested.append(QueryTokens.token(this.primaryFromAlias));
            }
        } else {
            builder.append(QueryTokens.token(this.countProjection));
            if (usesDistinct) {
                nested.append(QueryTokens.expression(ctx.DISTINCT()));
            }
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    private QueryRenderer.QueryRendererBuilder getDistinctCountSelection(QueryTokenStream selectionListbuilder) {
        QueryRenderer.QueryRendererBuilder nested = new QueryRenderer.QueryRendererBuilder();
        QueryTransformers.CountSelectionTokenStream countSelection = QueryTransformers.CountSelectionTokenStream.create(selectionListbuilder);
        if (countSelection.requiresPrimaryAlias()) {
            if (this.primaryFromAlias == null) {
                throw new IllegalStateException("Primary alias must be set for DISTINCT count selection using constructor expressions");
            }
            nested.append(QueryTokens.token(this.primaryFromAlias));
        } else {
            nested.append(countSelection);
        }
        return nested;
    }
}

