/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.Objects;
import org.springframework.data.jpa.repository.query.JpqlQueryBuilder;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class JpqlUtils {
    JpqlUtils() {
    }

    static JpqlQueryBuilder.PathExpression toExpressionRecursively(Metamodel metamodel, JpqlQueryBuilder.Origin source, Bindable<?> from, PropertyPath property) {
        return JpqlUtils.toExpressionRecursively(metamodel, source, from, property, false);
    }

    static JpqlQueryBuilder.PathExpression toExpressionRecursively(Metamodel metamodel, JpqlQueryBuilder.Origin source, Bindable<?> from, PropertyPath property, boolean isForSelection) {
        return JpqlUtils.toExpressionRecursively(metamodel, source, from, property, isForSelection, false);
    }

    static JpqlQueryBuilder.PathExpression toExpressionRecursively(Metamodel metamodel, JpqlQueryBuilder.Origin source, Bindable<?> from, PropertyPath property, boolean isForSelection, boolean hasRequiredOuterJoin) {
        JpqlQueryBuilder.Join joinSource;
        String segment = property.getSegment();
        boolean isLeafProperty = !property.hasNext();
        boolean requiresOuterJoin = JpqlUtils.requiresOuterJoin(metamodel, from, property, isForSelection, hasRequiredOuterJoin);
        if (!requiresOuterJoin && isLeafProperty) {
            return new JpqlQueryBuilder.PathAndOrigin(property, source, false);
        }
        JpqlQueryBuilder.Join join = joinSource = requiresOuterJoin ? JpqlQueryBuilder.leftJoin(source, segment) : JpqlQueryBuilder.innerJoin(source, segment);
        if (isLeafProperty) {
            return new JpqlQueryBuilder.PathAndOrigin(property, joinSource, true);
        }
        PropertyPath nextProperty = Objects.requireNonNull(property.next(), "An element of the property path is null");
        ManagedType<?> managedTypeForModel = QueryUtils.getManagedTypeForModel(from);
        Attribute<?, ?> nextAttribute = JpqlUtils.getModelForPath(metamodel, property, managedTypeForModel, from);
        return JpqlUtils.toExpressionRecursively(metamodel, joinSource, (Bindable)nextAttribute, nextProperty, isForSelection, requiresOuterJoin);
    }

    static boolean requiresOuterJoin(Metamodel metamodel, Bindable<?> bindable, PropertyPath propertyPath, boolean isForSelection, boolean hasRequiredOuterJoin) {
        boolean isLeafProperty;
        ManagedType<?> managedType = QueryUtils.getManagedTypeForModel(bindable);
        Attribute<?, ?> attribute = JpqlUtils.getModelForPath(metamodel, propertyPath, managedType, bindable);
        boolean isPluralAttribute = bindable instanceof PluralAttribute;
        if (attribute == null) {
            return isPluralAttribute;
        }
        if (!QueryUtils.ASSOCIATION_TYPES.containsKey(attribute.getPersistentAttributeType())) {
            return false;
        }
        boolean isCollection = attribute.isCollection();
        boolean isInverseOptionalOneToOne = Attribute.PersistentAttributeType.ONE_TO_ONE == attribute.getPersistentAttributeType() && StringUtils.hasText((String)QueryUtils.getAnnotationProperty(attribute, "mappedBy", ""));
        boolean bl = isLeafProperty = !propertyPath.hasNext();
        if (!(!isLeafProperty || isForSelection || isCollection || isInverseOptionalOneToOne || hasRequiredOuterJoin)) {
            return false;
        }
        return hasRequiredOuterJoin || QueryUtils.getAnnotationProperty(attribute, "optional", true) != false;
    }

    @Nullable
    private static Attribute<?, ?> getModelForPath(Metamodel metamodel, PropertyPath path, @Nullable ManagedType<?> managedType, Bindable<?> fallback) {
        String segment = path.getSegment();
        if (managedType != null) {
            try {
                return managedType.getAttribute(segment);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        Class fallbackType = fallback.getBindableJavaType();
        try {
            return metamodel.managedType(fallbackType).getAttribute(segment);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

