/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.stream.ByteBufferRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveStreamCommands {
    default public Mono<Long> xAck(ByteBuffer key, String group, String ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        return this.xAck((Publisher<AcknowledgeCommand>)Mono.just((Object)AcknowledgeCommand.stream(key).inGroup(group).forRecords(recordIds))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> xAck(ByteBuffer key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        return this.xAck((Publisher<AcknowledgeCommand>)Mono.just((Object)AcknowledgeCommand.stream(key).inGroup(group).forRecords(recordIds))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<AcknowledgeCommand, Long>> xAck(Publisher<AcknowledgeCommand> var1);

    default public Mono<RecordId> xAdd(ByteBuffer key, Map<ByteBuffer, ByteBuffer> body) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(body, (String)"Body must not be null!");
        return this.xAdd(StreamRecords.newRecord().in(key).ofBuffer(body));
    }

    default public Mono<RecordId> xAdd(ByteBufferRecord record) {
        Assert.notNull((Object)record, (String)"Record must not be null!");
        return this.xAdd((Publisher<AddStreamRecord>)Mono.just((Object)AddStreamRecord.of(record))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<AddStreamRecord, RecordId>> xAdd(Publisher<AddStreamRecord> var1);

    default public Mono<Long> xDel(ByteBuffer key, String ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)recordIds, (String)"RecordIds must not be null!");
        return this.xDel((Publisher<DeleteCommand>)Mono.just((Object)DeleteCommand.stream(key).records(recordIds))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> xDel(ByteBuffer key, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)recordIds, (String)"RecordIds must not be null!");
        return this.xDel((Publisher<DeleteCommand>)Mono.just((Object)DeleteCommand.stream(key).records(recordIds))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<DeleteCommand, Long>> xDel(Publisher<DeleteCommand> var1);

    default public Mono<Long> xLen(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.xLen((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> xLen(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Flux<ByteBufferRecord> xRange(ByteBuffer key, Range<String> range) {
        return this.xRange(key, range, RedisZSetCommands.Limit.unlimited());
    }

    default public Flux<ByteBufferRecord> xRange(ByteBuffer key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.xRange((Publisher<RangeCommand>)Mono.just((Object)RangeCommand.stream(key).within(range).limit(limit))).next().flatMapMany(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<RangeCommand, Flux<ByteBufferRecord>>> xRange(Publisher<RangeCommand> var1);

    default public Flux<ByteBufferRecord> xRead(StreamOffset<ByteBuffer> ... streams) {
        return this.xRead(StreamReadOptions.empty(), streams);
    }

    default public Flux<ByteBufferRecord> xRead(StreamReadOptions readOptions, StreamOffset<ByteBuffer> ... streams) {
        Assert.notNull((Object)readOptions, (String)"StreamReadOptions must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        return this.read((Publisher<ReadCommand>)Mono.just((Object)ReadCommand.from(streams).withOptions(readOptions))).next().flatMapMany(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReadCommand, Flux<ByteBufferRecord>>> read(Publisher<ReadCommand> var1);

    default public Mono<String> xGroupCreate(ByteBuffer key, String groupName, ReadOffset readOffset) {
        return this.xGroup((Publisher<GroupCommand>)Mono.just((Object)GroupCommand.createGroup(groupName).forStream(key).at(readOffset))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    @Nullable
    default public Mono<String> xGroupDelConsumer(ByteBuffer key, String groupName, String consumerName) {
        return this.xGroupDelConsumer(key, Consumer.from(groupName, consumerName));
    }

    default public Mono<String> xGroupDelConsumer(ByteBuffer key, Consumer consumer) {
        return this.xGroup(GroupCommand.deleteConsumer(consumer).forStream(key));
    }

    @Nullable
    default public Mono<String> xGroupDestroy(ByteBuffer key, String groupName) {
        return this.xGroup(GroupCommand.destroyGroup(groupName).forStream(key));
    }

    default public Mono<String> xGroup(GroupCommand command) {
        return this.xGroup((Publisher<GroupCommand>)Mono.just((Object)command)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<GroupCommand, String>> xGroup(Publisher<GroupCommand> var1);

    default public Flux<ByteBufferRecord> xReadGroup(Consumer consumer, StreamOffset<ByteBuffer> ... streams) {
        return this.xReadGroup(consumer, StreamReadOptions.empty(), streams);
    }

    default public Flux<ByteBufferRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<ByteBuffer> ... streams) {
        Assert.notNull((Object)consumer, (String)"Consumer must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        return this.read((Publisher<ReadCommand>)Mono.just((Object)ReadCommand.from(streams).withOptions(readOptions).as(consumer))).next().flatMapMany(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ByteBufferRecord> xRevRange(ByteBuffer key, Range<String> range) {
        return this.xRevRange(key, range, RedisZSetCommands.Limit.unlimited());
    }

    default public Flux<ByteBufferRecord> xRevRange(ByteBuffer key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.xRevRange((Publisher<RangeCommand>)Mono.just((Object)RangeCommand.stream(key).within(range).limit(limit))).next().flatMapMany(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<RangeCommand, Flux<ByteBufferRecord>>> xRevRange(Publisher<RangeCommand> var1);

    default public Mono<Long> xTrim(ByteBuffer key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.xTrim((Publisher<TrimCommand>)Mono.just((Object)TrimCommand.stream(key).to(count))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> xTrim(Publisher<TrimCommand> var1);

    public static class TrimCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private Long count;

        private TrimCommand(ByteBuffer key, @Nullable Long count) {
            super(key);
            this.count = count;
        }

        public static TrimCommand stream(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new TrimCommand(key, null);
        }

        public TrimCommand to(long count) {
            return new TrimCommand(this.getKey(), count);
        }

        @Nullable
        public Long getCount() {
            return this.count;
        }
    }

    public static class GroupCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final GroupCommandAction action;
        @Nullable
        private final String groupName;
        @Nullable
        private final String consumerName;
        @Nullable
        private final ReadOffset offset;

        public GroupCommand(@Nullable ByteBuffer key, GroupCommandAction action, @Nullable String groupName, @Nullable String consumerName, @Nullable ReadOffset offset) {
            super(key);
            this.action = action;
            this.groupName = groupName;
            this.consumerName = consumerName;
            this.offset = offset;
        }

        public static GroupCommand createGroup(String group) {
            return new GroupCommand(null, GroupCommandAction.CREATE, group, null, ReadOffset.latest());
        }

        public static GroupCommand destroyGroup(String group) {
            return new GroupCommand(null, GroupCommandAction.DESTROY, group, null, null);
        }

        public static GroupCommand deleteConsumer(String consumerName) {
            return new GroupCommand(null, GroupCommandAction.DELETE_CONSUMER, null, consumerName, null);
        }

        public static GroupCommand deleteConsumer(Consumer consumer) {
            return new GroupCommand(null, GroupCommandAction.DELETE_CONSUMER, consumer.getGroup(), consumer.getName(), null);
        }

        public GroupCommand at(ReadOffset offset) {
            return new GroupCommand(this.getKey(), this.action, this.groupName, this.consumerName, offset);
        }

        public GroupCommand forStream(ByteBuffer key) {
            return new GroupCommand(key, this.action, this.groupName, this.consumerName, this.offset);
        }

        public GroupCommand fromGroup(String groupName) {
            return new GroupCommand(this.getKey(), this.action, groupName, this.consumerName, this.offset);
        }

        @Nullable
        public ReadOffset getReadOffset() {
            return this.offset;
        }

        @Nullable
        public String getGroupName() {
            return this.groupName;
        }

        @Nullable
        public String getConsumerName() {
            return this.consumerName;
        }

        public GroupCommandAction getAction() {
            return this.action;
        }

        public static enum GroupCommandAction {
            CREATE,
            SET_ID,
            DESTROY,
            DELETE_CONSUMER;

        }
    }

    public static class ReadCommand {
        private final List<StreamOffset<ByteBuffer>> streamOffsets;
        @Nullable
        private final StreamReadOptions readOptions;
        @Nullable
        private final Consumer consumer;

        public ReadCommand(List<StreamOffset<ByteBuffer>> streamOffsets, @Nullable StreamReadOptions readOptions, @Nullable Consumer consumer) {
            this.readOptions = readOptions;
            this.consumer = consumer;
            this.streamOffsets = streamOffsets;
        }

        public static ReadCommand from(StreamOffset<ByteBuffer> streamOffset) {
            Assert.notNull(streamOffset, (String)"StreamOffset must not be null!");
            return new ReadCommand(Collections.singletonList(streamOffset), StreamReadOptions.empty(), null);
        }

        public static ReadCommand from(StreamOffset<ByteBuffer> ... streamOffsets) {
            Assert.notNull(streamOffsets, (String)"StreamOffsets must not be null!");
            return new ReadCommand(Arrays.asList(streamOffsets), StreamReadOptions.empty(), null);
        }

        public ReadCommand as(Consumer consumer) {
            Assert.notNull((Object)consumer, (String)"Consumer must not be null!");
            return new ReadCommand(this.getStreamOffsets(), this.getReadOptions(), consumer);
        }

        public ReadCommand withOptions(StreamReadOptions options) {
            Assert.notNull((Object)options, (String)"StreamReadOptions must not be null!");
            return new ReadCommand(this.getStreamOffsets(), options, this.getConsumer());
        }

        public List<StreamOffset<ByteBuffer>> getStreamOffsets() {
            return this.streamOffsets;
        }

        @Nullable
        public StreamReadOptions getReadOptions() {
            return this.readOptions;
        }

        @Nullable
        public Consumer getConsumer() {
            return this.consumer;
        }
    }

    public static class RangeCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<String> range;
        private final RedisZSetCommands.Limit limit;

        private RangeCommand(ByteBuffer key, Range<String> range, RedisZSetCommands.Limit limit) {
            super(key);
            this.range = range;
            this.limit = limit;
        }

        public static RangeCommand stream(ByteBuffer key) {
            return new RangeCommand(key, (Range<String>)Range.unbounded(), RedisZSetCommands.Limit.unlimited());
        }

        public RangeCommand within(Range<String> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new RangeCommand(this.getKey(), range, this.getLimit());
        }

        public RangeCommand limit(int count) {
            return new RangeCommand(this.getKey(), this.range, RedisZSetCommands.Limit.unlimited().count(count));
        }

        public RangeCommand limit(RedisZSetCommands.Limit limit) {
            Assert.notNull((Object)limit, (String)"Limit must not be null!");
            return new RangeCommand(this.getKey(), this.range, limit);
        }

        public Range<String> getRange() {
            return this.range;
        }

        public RedisZSetCommands.Limit getLimit() {
            return this.limit;
        }
    }

    public static class DeleteCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<RecordId> recordIds;

        private DeleteCommand(@Nullable ByteBuffer key, List<RecordId> recordIds) {
            super(key);
            this.recordIds = recordIds;
        }

        public static DeleteCommand stream(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new DeleteCommand(key, Collections.emptyList());
        }

        public DeleteCommand records(String ... recordIds) {
            Assert.notNull((Object)recordIds, (String)"RecordIds must not be null!");
            return this.records((RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
        }

        public DeleteCommand records(RecordId ... recordIds) {
            Assert.notNull((Object)recordIds, (String)"RecordIds must not be null!");
            ArrayList<RecordId> newrecordIds = new ArrayList<RecordId>(this.getRecordIds().size() + recordIds.length);
            newrecordIds.addAll(this.getRecordIds());
            newrecordIds.addAll(Arrays.asList(recordIds));
            return new DeleteCommand(this.getKey(), newrecordIds);
        }

        public List<RecordId> getRecordIds() {
            return this.recordIds;
        }
    }

    public static class AddStreamRecord
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBufferRecord record;

        private AddStreamRecord(ByteBufferRecord record) {
            super((ByteBuffer)record.getStream());
            this.record = record;
        }

        public static AddStreamRecord of(ByteBufferRecord record) {
            Assert.notNull((Object)record, (String)"Record must not be null!");
            return new AddStreamRecord(record);
        }

        public static AddStreamRecord body(Map<ByteBuffer, ByteBuffer> body) {
            Assert.notNull(body, (String)"Body must not be null!");
            return new AddStreamRecord(StreamRecords.rawBuffer(body));
        }

        public AddStreamRecord to(ByteBuffer key) {
            return new AddStreamRecord(this.record.withStreamKey(key));
        }

        public Map<ByteBuffer, ByteBuffer> getBody() {
            return (Map)this.record.getValue();
        }

        public ByteBufferRecord getRecord() {
            return this.record;
        }
    }

    public static class AcknowledgeCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private final String group;
        private final List<RecordId> recordIds;

        private AcknowledgeCommand(@Nullable ByteBuffer key, @Nullable String group, List<RecordId> recordIds) {
            super(key);
            this.group = group;
            this.recordIds = recordIds;
        }

        public static AcknowledgeCommand stream(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new AcknowledgeCommand(key, null, Collections.emptyList());
        }

        public AcknowledgeCommand forRecords(String ... recordIds) {
            Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
            return this.forRecords((RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
        }

        public AcknowledgeCommand forRecords(RecordId ... recordIds) {
            Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
            ArrayList<RecordId> newrecordIds = new ArrayList<RecordId>(this.getRecordIds().size() + recordIds.length);
            newrecordIds.addAll(this.getRecordIds());
            newrecordIds.addAll(Arrays.asList(recordIds));
            return new AcknowledgeCommand(this.getKey(), this.getGroup(), newrecordIds);
        }

        public AcknowledgeCommand inGroup(String group) {
            Assert.notNull((Object)group, (String)"Group must not be null!");
            return new AcknowledgeCommand(this.getKey(), group, this.getRecordIds());
        }

        @Nullable
        public String getGroup() {
            return this.group;
        }

        public List<RecordId> getRecordIds() {
            return this.recordIds;
        }
    }
}

