/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceGeoCommands
implements RedisGeoCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public Long geoAdd(byte[] key, Point point, byte[] member) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)point, (String)"Point must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().geoadd((Object)key, point.getX(), point.getY(), (Object)member)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().geoadd((Object)key, point.getX(), point.getY(), (Object)member)));
                return null;
            }
            return this.getConnection().geoadd((Object)key, point.getX(), point.getY(), (Object)member);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(memberCoordinateMap, (String)"MemberCoordinateMap must not be null!");
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<byte[], Point> entry : memberCoordinateMap.entrySet()) {
            values.add(entry.getValue().getX());
            values.add(entry.getValue().getY());
            values.add(entry.getKey());
        }
        return this.geoAdd(key, (Collection<Object>)values);
    }

    @Override
    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(locations, (String)"Locations must not be null!");
        ArrayList<Object> values = new ArrayList<Object>();
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            values.add(location.getPoint().getX());
            values.add(location.getPoint().getY());
            values.add(location.getName());
        }
        return this.geoAdd(key, (Collection<Object>)values);
    }

    @Nullable
    private Long geoAdd(byte[] key, Collection<Object> values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().geoadd((Object)key, values.toArray())));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().geoadd((Object)key, values.toArray())));
                return null;
            }
            return this.getConnection().geoadd((Object)key, values.toArray());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        return this.geoDist(key, member1, member2, RedisGeoCommands.DistanceUnit.METERS);
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member1, (String)"Member1 must not be null!");
        Assert.notNull((Object)member2, (String)"Member2 must not be null!");
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(metric);
        Converter<Double, Distance> distanceConverter = LettuceConverters.distanceConverterForMetric(metric);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().geodist((Object)key, (Object)member1, (Object)member2, geoUnit), distanceConverter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().geodist((Object)key, (Object)member1, (Object)member2, geoUnit), distanceConverter));
                return null;
            }
            return (Distance)distanceConverter.convert((Object)this.getConnection().geodist((Object)key, (Object)member1, (Object)member2, geoUnit));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<String> geoHash(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().geohash((Object)key, (Object[])members)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().geohash((Object)key, (Object[])members)));
                return null;
            }
            return this.getConnection().geohash((Object)key, (Object[])members).stream().map(value -> (String)value.getValueOrElse(null)).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<Point> geoPos(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        ListConverter<GeoCoordinates, Point> converter = LettuceConverters.geoCoordinatesToPointConverter();
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().geopos((Object)key, (Object[])members), converter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().geopos((Object)key, (Object[])members), converter));
                return null;
            }
            return converter.convert(this.getConnection().geopos((Object)key, (Object[])members));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        Converter<Set<byte[]>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoResultsConverter = LettuceConverters.bytesSetToGeoResultsConverter();
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric())), geoResultsConverter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric())), geoResultsConverter));
                return null;
            }
            return (GeoResults)geoResultsConverter.convert((Object)this.getConnection().georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric())));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoArgs geoArgs = LettuceConverters.toGeoArgs(args);
        Converter<List<GeoWithin<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoResultsConverter = LettuceConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric());
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric()), geoArgs), geoResultsConverter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric()), geoArgs), geoResultsConverter));
                return null;
            }
            return (GeoResults)geoResultsConverter.convert((Object)this.getConnection().georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric()), geoArgs));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, (Metric)RedisGeoCommands.DistanceUnit.METERS));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(radius.getMetric());
        Converter<Set<byte[]>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = LettuceConverters.bytesSetToGeoResultsConverter();
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().georadiusbymember((Object)key, (Object)member, radius.getValue(), geoUnit), converter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().georadiusbymember((Object)key, (Object)member, radius.getValue(), geoUnit), converter));
                return null;
            }
            return (GeoResults)converter.convert((Object)this.getConnection().georadiusbymember((Object)key, (Object)member, radius.getValue(), geoUnit));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(radius.getMetric());
        GeoArgs geoArgs = LettuceConverters.toGeoArgs(args);
        Converter<List<GeoWithin<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoResultsConverter = LettuceConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric());
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().georadiusbymember((Object)key, (Object)member, radius.getValue(), geoUnit, geoArgs), geoResultsConverter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().georadiusbymember((Object)key, (Object)member, radius.getValue(), geoUnit, geoArgs), geoResultsConverter));
                return null;
            }
            return (GeoResults)geoResultsConverter.convert((Object)this.getConnection().georadiusbymember((Object)key, (Object)member, radius.getValue(), geoUnit, geoArgs));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long geoRemove(byte[] key, byte[] ... values) {
        return this.connection.zSetCommands().zRem(key, values);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    public LettuceGeoCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

