/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

class JedisSetCommands
implements RedisSetCommands {
    private final JedisConnection connection;

    JedisSetCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::sadd, PipelineBase::sadd, key, values);
    }

    @Override
    public Long sCard(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::scard, PipelineBase::scard, key);
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::sdiff, MultiKeyPipelineBase::sdiff, keys);
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)keys, (String)"Source keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::sdiffstore, MultiKeyPipelineBase::sdiffstore, destKey, keys);
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::sinter, MultiKeyPipelineBase::sinter, keys);
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)keys, (String)"Source keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::sinterstore, MultiKeyPipelineBase::sinterstore, destKey, keys);
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().just(BinaryJedis::sismember, PipelineBase::sismember, key, value);
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::smembers, PipelineBase::smembers, key);
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return (Boolean)this.connection.invoke().from(BinaryJedis::smove, MultiKeyPipelineBase::smove, srcKey, destKey, value).get(Converters::toBoolean);
    }

    @Override
    public byte[] sPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::spop, PipelineBase::spop, key);
    }

    @Override
    public List<byte[]> sPop(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (List)this.connection.invoke().from(BinaryJedis::spop, PipelineBase::spop, key, count).get(ArrayList::new);
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::srandmember, PipelineBase::srandmember, key);
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count must be less than Integer.MAX_VALUE for sRandMember in Jedis.");
        }
        return this.connection.invoke().just(BinaryJedis::srandmember, PipelineBase::srandmember, key, (int)count);
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::srem, PipelineBase::srem, key, values);
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::sunion, MultiKeyPipelineBase::sunion, keys);
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)keys, (String)"Source keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::sunionstore, MultiKeyPipelineBase::sunionstore, destKey, keys);
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return this.sScan(key, 0L, options);
    }

    public Cursor<byte[]> sScan(byte[] key, long cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new KeyBoundCursor<byte[]>(key, cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisSetCommands.this.isQueueing() || JedisSetCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisSetCommands.this.connection.getJedis().sscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getCursor()), result.getResult());
            }

            @Override
            protected void doClose() {
                JedisSetCommands.this.connection.close();
            }
        }.open();
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

