/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.api.async.RedisGeoAsyncCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceGeoCommands
implements RedisGeoCommands {
    private final LettuceConnection connection;

    LettuceGeoCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long geoAdd(byte[] key, Point point, byte[] member) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)point, (String)"Point must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        return (Long)this.connection.invoke().just(RedisGeoAsyncCommands::geoadd, key, point.getX(), point.getY(), member);
    }

    @Override
    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(memberCoordinateMap, (String)"MemberCoordinateMap must not be null!");
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<byte[], Point> entry : memberCoordinateMap.entrySet()) {
            values.add(entry.getValue().getX());
            values.add(entry.getValue().getY());
            values.add(entry.getKey());
        }
        return this.geoAdd(key, (Collection<Object>)values);
    }

    @Override
    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(locations, (String)"Locations must not be null!");
        ArrayList<Object> values = new ArrayList<Object>();
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            values.add(location.getPoint().getX());
            values.add(location.getPoint().getY());
            values.add(location.getName());
        }
        return this.geoAdd(key, (Collection<Object>)values);
    }

    @Nullable
    private Long geoAdd(byte[] key, Collection<Object> values) {
        return (Long)this.connection.invoke().just(it -> it.geoadd((Object)key, values.toArray()));
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        return this.geoDist(key, member1, member2, RedisGeoCommands.DistanceUnit.METERS);
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member1, (String)"Member1 must not be null!");
        Assert.notNull((Object)member2, (String)"Member2 must not be null!");
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(metric);
        Converter<Double, Distance> distanceConverter = LettuceConverters.distanceConverterForMetric(metric);
        return this.connection.invoke().from(RedisGeoAsyncCommands::geodist, key, member1, member2, geoUnit).get(distanceConverter);
    }

    @Override
    public List<String> geoHash(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        return this.connection.invoke().fromMany(RedisGeoAsyncCommands::geohash, key, members).toList(it -> (String)it.getValueOrElse(null));
    }

    @Override
    public List<Point> geoPos(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        return this.connection.invoke().fromMany(RedisGeoAsyncCommands::geopos, key, members).toList(LettuceConverters::geoCoordinatesToPoint);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        Converter<Set<byte[]>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoResultsConverter = LettuceConverters.bytesSetToGeoResultsConverter();
        return this.connection.invoke().from(it -> it.georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric()))).get(geoResultsConverter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoArgs geoArgs = LettuceConverters.toGeoArgs(args);
        Converter<List<GeoWithin<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoResultsConverter = LettuceConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric());
        return this.connection.invoke().from(it -> it.georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric()), geoArgs)).get(geoResultsConverter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, (Metric)RedisGeoCommands.DistanceUnit.METERS));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(radius.getMetric());
        Converter<Set<byte[]>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = LettuceConverters.bytesSetToGeoResultsConverter();
        return this.connection.invoke().from(RedisGeoAsyncCommands::georadiusbymember, key, member, radius.getValue(), geoUnit).get(converter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(radius.getMetric());
        GeoArgs geoArgs = LettuceConverters.toGeoArgs(args);
        Converter<List<GeoWithin<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoResultsConverter = LettuceConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric());
        return this.connection.invoke().from(RedisGeoAsyncCommands::georadiusbymember, key, member, radius.getValue(), geoUnit, geoArgs).get(geoResultsConverter);
    }

    @Override
    public Long geoRemove(byte[] key, byte[] ... values) {
        return this.connection.zSetCommands().zRem(key, values);
    }
}

