/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface ZSetOperations<K, V> {
    @Nullable
    public Boolean add(K var1, V var2, double var3);

    @Nullable
    public Boolean addIfAbsent(K var1, V var2, double var3);

    @Nullable
    public Long add(K var1, Set<TypedTuple<V>> var2);

    @Nullable
    public Long addIfAbsent(K var1, Set<TypedTuple<V>> var2);

    @Nullable
    public Long remove(K var1, Object ... var2);

    @Nullable
    public Double incrementScore(K var1, V var2, double var3);

    public V randomMember(K var1);

    @Nullable
    public Set<V> distinctRandomMembers(K var1, long var2);

    @Nullable
    public List<V> randomMembers(K var1, long var2);

    public TypedTuple<V> randomMemberWithScore(K var1);

    @Nullable
    public Set<TypedTuple<V>> distinctRandomMembersWithScore(K var1, long var2);

    @Nullable
    public List<TypedTuple<V>> randomMembersWithScore(K var1, long var2);

    @Nullable
    public Long rank(K var1, Object var2);

    @Nullable
    public Long reverseRank(K var1, Object var2);

    @Nullable
    public Set<V> range(K var1, long var2, long var4);

    @Nullable
    public Set<TypedTuple<V>> rangeWithScores(K var1, long var2, long var4);

    @Nullable
    public Set<V> rangeByScore(K var1, double var2, double var4);

    @Nullable
    public Set<TypedTuple<V>> rangeByScoreWithScores(K var1, double var2, double var4);

    @Nullable
    public Set<V> rangeByScore(K var1, double var2, double var4, long var6, long var8);

    @Nullable
    public Set<TypedTuple<V>> rangeByScoreWithScores(K var1, double var2, double var4, long var6, long var8);

    @Nullable
    public Set<V> reverseRange(K var1, long var2, long var4);

    @Nullable
    public Set<TypedTuple<V>> reverseRangeWithScores(K var1, long var2, long var4);

    @Nullable
    public Set<V> reverseRangeByScore(K var1, double var2, double var4);

    @Nullable
    public Set<TypedTuple<V>> reverseRangeByScoreWithScores(K var1, double var2, double var4);

    @Nullable
    public Set<V> reverseRangeByScore(K var1, double var2, double var4, long var6, long var8);

    @Nullable
    public Set<TypedTuple<V>> reverseRangeByScoreWithScores(K var1, double var2, double var4, long var6, long var8);

    @Nullable
    public Long count(K var1, double var2, double var4);

    @Nullable
    public Long lexCount(K var1, RedisZSetCommands.Range var2);

    @Nullable
    public TypedTuple<V> popMin(K var1);

    @Nullable
    public Set<TypedTuple<V>> popMin(K var1, long var2);

    @Nullable
    public TypedTuple<V> popMin(K var1, long var2, TimeUnit var4);

    @Nullable
    default public TypedTuple<V> popMin(K key, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.popMin(key, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    @Nullable
    public TypedTuple<V> popMax(K var1);

    @Nullable
    public Set<TypedTuple<V>> popMax(K var1, long var2);

    @Nullable
    public TypedTuple<V> popMax(K var1, long var2, TimeUnit var4);

    @Nullable
    default public TypedTuple<V> popMax(K key, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.popMin(key, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    @Nullable
    public Long size(K var1);

    @Nullable
    public Long zCard(K var1);

    @Nullable
    public Double score(K var1, Object var2);

    @Nullable
    public List<Double> score(K var1, Object ... var2);

    @Nullable
    public Long removeRange(K var1, long var2, long var4);

    @Nullable
    public Long removeRangeByLex(K var1, RedisZSetCommands.Range var2);

    @Nullable
    public Long removeRangeByScore(K var1, double var2, double var4);

    @Nullable
    default public Set<V> difference(K key, K otherKey) {
        return this.difference(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<V> difference(K var1, Collection<K> var2);

    @Nullable
    default public Set<TypedTuple<V>> differenceWithScores(K key, K otherKey) {
        return this.differenceWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<TypedTuple<V>> differenceWithScores(K var1, Collection<K> var2);

    @Nullable
    public Long differenceAndStore(K var1, Collection<K> var2, K var3);

    @Nullable
    default public Set<V> intersect(K key, K otherKey) {
        return this.intersect(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<V> intersect(K var1, Collection<K> var2);

    @Nullable
    default public Set<TypedTuple<V>> intersectWithScores(K key, K otherKey) {
        return this.intersectWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<TypedTuple<V>> intersectWithScores(K var1, Collection<K> var2);

    @Nullable
    default public Set<TypedTuple<V>> intersectWithScores(K key, Collection<K> otherKeys, RedisZSetCommands.Aggregate aggregate) {
        return this.intersectWithScores(key, otherKeys, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    @Nullable
    public Set<TypedTuple<V>> intersectWithScores(K var1, Collection<K> var2, RedisZSetCommands.Aggregate var3, RedisZSetCommands.Weights var4);

    @Nullable
    public Long intersectAndStore(K var1, K var2, K var3);

    @Nullable
    public Long intersectAndStore(K var1, Collection<K> var2, K var3);

    @Nullable
    default public Long intersectAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.intersectAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    @Nullable
    public Long intersectAndStore(K var1, Collection<K> var2, K var3, RedisZSetCommands.Aggregate var4, RedisZSetCommands.Weights var5);

    @Nullable
    default public Set<V> union(K key, K otherKey) {
        return this.union(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<V> union(K var1, Collection<K> var2);

    @Nullable
    default public Set<TypedTuple<V>> unionWithScores(K key, K otherKey) {
        return this.unionWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<TypedTuple<V>> unionWithScores(K var1, Collection<K> var2);

    @Nullable
    default public Set<TypedTuple<V>> unionWithScores(K key, Collection<K> otherKeys, RedisZSetCommands.Aggregate aggregate) {
        return this.unionWithScores(key, otherKeys, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    @Nullable
    public Set<TypedTuple<V>> unionWithScores(K var1, Collection<K> var2, RedisZSetCommands.Aggregate var3, RedisZSetCommands.Weights var4);

    @Nullable
    public Long unionAndStore(K var1, K var2, K var3);

    @Nullable
    public Long unionAndStore(K var1, Collection<K> var2, K var3);

    @Nullable
    default public Long unionAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.unionAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    @Nullable
    public Long unionAndStore(K var1, Collection<K> var2, K var3, RedisZSetCommands.Aggregate var4, RedisZSetCommands.Weights var5);

    public Cursor<TypedTuple<V>> scan(K var1, ScanOptions var2);

    @Nullable
    default public Set<V> rangeByLex(K key, RedisZSetCommands.Range range) {
        return this.rangeByLex(key, range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public Set<V> rangeByLex(K var1, RedisZSetCommands.Range var2, RedisZSetCommands.Limit var3);

    @Nullable
    default public Set<V> reverseRangeByLex(K key, RedisZSetCommands.Range range) {
        return this.reverseRangeByLex(key, range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public Set<V> reverseRangeByLex(K var1, RedisZSetCommands.Range var2, RedisZSetCommands.Limit var3);

    public RedisOperations<K, V> getOperations();

    public static interface TypedTuple<V>
    extends Comparable<TypedTuple<V>> {
        @Nullable
        public V getValue();

        @Nullable
        public Double getScore();

        public static <V> TypedTuple<V> of(V value, @Nullable Double score) {
            return new DefaultTypedTuple<V>(value, score);
        }
    }
}

