/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.core.ReactiveHyperLogLogOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveHyperLogLogOperations<K, V>
implements ReactiveHyperLogLogOperations<K, V> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<K, V> serializationContext;

    DefaultReactiveHyperLogLogOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<K, V> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    @SafeVarargs
    public final Mono<Long> add(K key, V ... values) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notEmpty((Object[])values, (String)"Values must not be null or empty!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        return this.createMono(connection -> Flux.fromArray((Object[])values).map(this::rawValue).collectList().flatMap(serializedValues -> connection.pfAdd(this.rawKey(key), (Collection<ByteBuffer>)serializedValues)));
    }

    @Override
    @SafeVarargs
    public final Mono<Long> size(K ... keys) {
        Assert.notEmpty((Object[])keys, (String)"Keys must not be null or empty!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return this.createMono(connection -> Flux.fromArray((Object[])keys).map(this::rawKey).collectList().flatMap(connection::pfCount));
    }

    @Override
    @SafeVarargs
    public final Mono<Boolean> union(K destination, K ... sourceKeys) {
        Assert.notNull(destination, (String)"Destination key must not be null!");
        Assert.notEmpty((Object[])sourceKeys, (String)"Source keys must not be null or empty!");
        Assert.noNullElements((Object[])sourceKeys, (String)"Source keys must not contain null elements!");
        return this.createMono(connection -> Flux.fromArray((Object[])sourceKeys).map(this::rawKey).collectList().flatMap(serialized -> connection.pfMerge(this.rawKey(destination), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.template.doCreateMono(connection -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveHyperLogLogCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.hyperLogLogCommands()));
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }
}

