/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ProjectionDefinitionConfiguration
implements ProjectionDefinitions {
    private static final String PROJECTION_ANNOTATION_NOT_FOUND = "Projection annotation not found on %s! Either add the annotation or hand source type to the registration manually!";
    private static final String DEFAULT_PROJECTION_PARAMETER_NAME = "projection";
    private final Map<ProjectionDefinitionKey, Class<?>> projectionDefinitions;
    private String parameterName = "projection";

    public ProjectionDefinitionConfiguration() {
        this(Collections.emptySet());
    }

    public ProjectionDefinitionConfiguration(Iterable<ResourceMetadata> resourceMetadata) {
        Assert.notNull(resourceMetadata, (String)"ResourceMetadata must not be null!");
        this.projectionDefinitions = new HashMap();
        for (ResourceMetadata metadata : resourceMetadata) {
            Class<?> projection = metadata.getExcerptProjection();
            if (projection == null) continue;
            this.addProjection(projection);
        }
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = StringUtils.hasText((String)parameterName) ? parameterName : DEFAULT_PROJECTION_PARAMETER_NAME;
    }

    public ProjectionDefinitionConfiguration addProjection(Class<?> projectionType) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        Projection annotation = (Projection)AnnotationUtils.findAnnotation(projectionType, Projection.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format(PROJECTION_ANNOTATION_NOT_FOUND, projectionType));
        }
        String name = annotation.name();
        Class<?>[] sourceTypes = annotation.types();
        return StringUtils.hasText((String)name) ? this.addProjection(projectionType, name, sourceTypes) : this.addProjection(projectionType, sourceTypes);
    }

    public ProjectionDefinitionConfiguration addProjection(Class<?> projectionType, Class<?> ... sourceTypes) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        return this.addProjection(projectionType, StringUtils.uncapitalize((String)projectionType.getSimpleName()), sourceTypes);
    }

    public ProjectionDefinitionConfiguration addProjection(Class<?> projectionType, String name, Class<?> ... sourceTypes) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        Assert.notEmpty((Object[])sourceTypes, (String)"Source types must not be null!");
        for (Class<?> sourceType : sourceTypes) {
            this.projectionDefinitions.put(new ProjectionDefinitionKey(sourceType, name), projectionType);
        }
        return this;
    }

    @Override
    public Class<?> getProjectionType(Class<?> sourceType, String name) {
        return this.getProjectionsFor(sourceType).get(name);
    }

    @Override
    public boolean hasProjectionFor(Class<?> sourceType) {
        for (ProjectionDefinitionKey key : this.projectionDefinitions.keySet()) {
            if (!key.sourceType.isAssignableFrom(sourceType)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Class<?>> getProjectionsFor(Class<?> sourceType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        Class userType = ClassUtils.getUserClass(sourceType);
        HashMap result = new HashMap();
        for (Map.Entry<ProjectionDefinitionKey, Class<?>> entry : this.projectionDefinitions.entrySet()) {
            if (!entry.getKey().sourceType.isAssignableFrom(userType)) continue;
            result.put(entry.getKey().name, entry.getValue());
        }
        return result;
    }

    static final class ProjectionDefinitionKey {
        private final Class<?> sourceType;
        private final String name;

        public ProjectionDefinitionKey(Class<?> sourceType, String name) {
            Assert.notNull(sourceType, (String)"Source type must not be null!");
            Assert.hasText((String)name, (String)"Name must not be null or empty!");
            this.sourceType = sourceType;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProjectionDefinitionKey)) {
                return false;
            }
            ProjectionDefinitionKey that = (ProjectionDefinitionKey)obj;
            return this.name.equals(that.name) && this.sourceType.equals(that.sourceType);
        }

        public int hashCode() {
            int result = 31;
            result += this.name.hashCode();
            return result += this.sourceType.hashCode();
        }
    }
}

