/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.mapping.MappingResourceMetadata;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.PersistentPropertyResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class PersistentEntitiesResourceMappings
implements ResourceMappings {
    private final PersistentEntities entities;
    private final SearchResourceMappings searchResourceMappings = new SearchResourceMappings(Collections.<MethodResourceMapping>emptyList());
    private final Map<Class<?>, ResourceMetadata> cache = new HashMap();
    private final Map<Class<?>, MappingResourceMetadata> mappingCache = new HashMap();
    private final Map<PersistentProperty<?>, ResourceMapping> propertyCache = new HashMap();

    public PersistentEntitiesResourceMappings(PersistentEntities entities) {
        this.entities = entities;
    }

    @Override
    public ResourceMetadata getMetadataFor(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        type = ClassUtils.getUserClass(type);
        if (this.cache.containsKey(type)) {
            return this.cache.get(type);
        }
        MappingResourceMetadata metadata = this.getMappingMetadataFor(type);
        this.cache.put(type, metadata);
        return metadata;
    }

    MappingResourceMetadata getMappingMetadataFor(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        type = ClassUtils.getUserClass(type);
        MappingResourceMetadata mappingMetadata = this.mappingCache.get(type);
        if (mappingMetadata != null) {
            return mappingMetadata;
        }
        PersistentEntity entity = this.entities.getPersistentEntity(type);
        if (entity == null) {
            return null;
        }
        mappingMetadata = new MappingResourceMetadata(entity, this);
        this.mappingCache.put(type, mappingMetadata);
        return mappingMetadata;
    }

    @Override
    public SearchResourceMappings getSearchResourceMappings(Class<?> domainType) {
        return this.searchResourceMappings;
    }

    @Override
    public boolean exportsMappingFor(Class<?> type) {
        if (!this.hasMappingFor(type)) {
            return false;
        }
        ResourceMetadata metadata = this.getMetadataFor(type);
        return metadata.isExported();
    }

    @Override
    public boolean exportsTopLevelResourceFor(String path) {
        Assert.hasText((String)path);
        for (ResourceMetadata metadata : this) {
            if (!metadata.getPath().matches(path)) continue;
            return metadata.isExported();
        }
        return false;
    }

    @Override
    public boolean hasMappingFor(Class<?> type) {
        return this.cache.containsKey(type);
    }

    public ResourceMapping getMappingFor(PersistentProperty<?> property) {
        ResourceMapping propertyMapping = this.propertyCache.get(property);
        if (propertyMapping != null) {
            return propertyMapping;
        }
        propertyMapping = new PersistentPropertyResourceMapping(property, this);
        this.propertyCache.put(property, propertyMapping);
        return propertyMapping;
    }

    public boolean isMapped(PersistentProperty<?> property) {
        ResourceMapping metadata = this.getMappingFor(property);
        return metadata != null && metadata.isExported();
    }

    @Override
    public Iterator<ResourceMetadata> iterator() {
        HashSet<ResourceMetadata> metadata = new HashSet<ResourceMetadata>();
        for (ResourceMetadata candidate : this.cache.values()) {
            if (candidate == null) continue;
            metadata.add(candidate);
        }
        return metadata.iterator();
    }

    protected final void addToCache(Class<?> type, ResourceMetadata metadata) {
        this.cache.put(type, metadata);
    }

    protected final boolean hasMetadataFor(Class<?> type) {
        return this.cache.containsKey(type);
    }
}

