/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Future;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.aws.outbound.AbstractAwsMessageHandler;
import org.springframework.integration.aws.outbound.ConvertingFromMessageConverter;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.MutableMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KinesisMessageHandler
extends AbstractAwsMessageHandler<Void> {
    private final AmazonKinesisAsync amazonKinesis;
    private MessageConverter messageConverter = new ConvertingFromMessageConverter((Converter<Object, ?>)new SerializingConverter());
    private Expression streamExpression;
    private Expression partitionKeyExpression;
    private Expression explicitHashKeyExpression;
    private Expression sequenceNumberExpression;
    private OutboundMessageMapper<byte[]> embeddedHeadersMapper;

    public KinesisMessageHandler(AmazonKinesisAsync amazonKinesis) {
        Assert.notNull((Object)amazonKinesis, (String)"'amazonKinesis' must not be null.");
        this.amazonKinesis = amazonKinesis;
    }

    @Deprecated
    public void setConverter(Converter<Object, byte[]> converter) {
        this.setMessageConverter(new ConvertingFromMessageConverter(converter));
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null.");
        this.messageConverter = messageConverter;
    }

    public void setStream(String stream) {
        this.setStreamExpression((Expression)new LiteralExpression(stream));
    }

    public void setStreamExpressionString(String streamExpression) {
        this.setStreamExpression(EXPRESSION_PARSER.parseExpression(streamExpression));
    }

    public void setStreamExpression(Expression streamExpression) {
        this.streamExpression = streamExpression;
    }

    public void setPartitionKey(String partitionKey) {
        this.setPartitionKeyExpression((Expression)new LiteralExpression(partitionKey));
    }

    public void setPartitionKeyExpressionString(String partitionKeyExpression) {
        this.setPartitionKeyExpression(EXPRESSION_PARSER.parseExpression(partitionKeyExpression));
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    public void setExplicitHashKey(String explicitHashKey) {
        this.setExplicitHashKeyExpression((Expression)new LiteralExpression(explicitHashKey));
    }

    public void setExplicitHashKeyExpressionString(String explicitHashKeyExpression) {
        this.setExplicitHashKeyExpression(EXPRESSION_PARSER.parseExpression(explicitHashKeyExpression));
    }

    public void setExplicitHashKeyExpression(Expression explicitHashKeyExpression) {
        this.explicitHashKeyExpression = explicitHashKeyExpression;
    }

    public void setSequenceNumberExpressionString(String sequenceNumberExpression) {
        this.setSequenceNumberExpression(EXPRESSION_PARSER.parseExpression(sequenceNumberExpression));
    }

    public void setSequenceNumberExpression(Expression sequenceNumberExpression) {
        this.sequenceNumberExpression = sequenceNumberExpression;
    }

    public void setEmbeddedHeadersMapper(OutboundMessageMapper<byte[]> embeddedHeadersMapper) {
        this.embeddedHeadersMapper = embeddedHeadersMapper;
    }

    @Override
    public void setHeaderMapper(HeaderMapper<Void> headerMapper) {
        throw new UnsupportedOperationException("Kinesis doesn't support headers.\nConsider to use 'OutboundMessageMapper<byte[]>' for embedding headers into the record data.");
    }

    @Override
    protected Future<?> handleMessageToAws(Message<?> message) {
        if (message.getPayload() instanceof PutRecordsRequest) {
            AsyncHandler asyncHandler = this.obtainAsyncHandler(message, (AmazonWebServiceRequest)((PutRecordsRequest)message.getPayload()));
            return this.amazonKinesis.putRecordsAsync((PutRecordsRequest)message.getPayload(), asyncHandler);
        }
        PutRecordRequest putRecordRequest = message.getPayload() instanceof PutRecordRequest ? (PutRecordRequest)message.getPayload() : this.buildPutRecordRequest(message);
        AsyncHandler asyncHandler = this.obtainAsyncHandler(message, (AmazonWebServiceRequest)putRecordRequest);
        return this.amazonKinesis.putRecordAsync(putRecordRequest, asyncHandler);
    }

    private PutRecordRequest buildPutRecordRequest(Message<?> message) {
        byte[] bytes;
        MessageHeaders messageHeaders = message.getHeaders();
        String stream = (String)messageHeaders.get((Object)"aws_stream", String.class);
        if (!StringUtils.hasText((String)stream) && this.streamExpression != null) {
            stream = (String)this.streamExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Assert.state((stream != null ? 1 : 0) != 0, (String)"'stream' must not be null for sending a Kinesis record. Consider configuring this handler with a 'stream'( or 'streamExpression') or supply an 'aws_stream' message header.");
        String partitionKey = (String)messageHeaders.get((Object)"aws_partitionKey", String.class);
        if (!StringUtils.hasText((String)partitionKey) && this.partitionKeyExpression != null) {
            partitionKey = (String)this.partitionKeyExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Assert.state((partitionKey != null ? 1 : 0) != 0, (String)"'partitionKey' must not be null for sending a Kinesis record. Consider configuring this handler with a 'partitionKey'( or 'partitionKeyExpression') or supply an 'aws_partitionKey' message header.");
        String explicitHashKey = this.explicitHashKeyExpression != null ? (String)this.explicitHashKeyExpression.getValue(this.getEvaluationContext(), message, String.class) : null;
        String sequenceNumber = (String)messageHeaders.get((Object)"aws_sequenceNumber", String.class);
        if (!StringUtils.hasText((String)sequenceNumber) && this.sequenceNumberExpression != null) {
            sequenceNumber = (String)this.sequenceNumberExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Object payload = message.getPayload();
        ByteBuffer data = null;
        MutableMessage messageToEmbed = null;
        if (payload instanceof ByteBuffer) {
            data = (ByteBuffer)payload;
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)data.array(), (Map)messageHeaders);
            }
        } else {
            bytes = (byte[])(payload instanceof byte[] ? payload : this.messageConverter.fromMessage(message, byte[].class));
            Assert.notNull((Object)bytes, (String)"payload cannot be null");
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)bytes, (Map)messageHeaders);
            } else {
                data = ByteBuffer.wrap(bytes);
            }
        }
        if (messageToEmbed != null) {
            try {
                bytes = (byte[])this.embeddedHeadersMapper.fromMessage((Message)messageToEmbed);
                Assert.notNull((Object)bytes, (String)"payload cannot be null");
                data = ByteBuffer.wrap(bytes);
            }
            catch (Exception ex) {
                throw new MessageConversionException(message, "Cannot embedded headers to payload", (Throwable)ex);
            }
        }
        return new PutRecordRequest().withStreamName(stream).withPartitionKey(partitionKey).withExplicitHashKey(explicitHashKey).withSequenceNumberForOrdering(sequenceNumber).withData(data);
    }

    @Override
    protected void additionalOnSuccessHeaders(AbstractIntegrationMessageBuilder<?> messageBuilder, AmazonWebServiceRequest request, Object result) {
        if (result instanceof PutRecordResult) {
            messageBuilder.setHeader("aws_shard", (Object)((PutRecordResult)result).getShardId()).setHeader("aws_sequenceNumber", (Object)((PutRecordResult)result).getSequenceNumber());
        }
    }
}

