/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.inbound.kinesis;

import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.aws.inbound.kinesis.Checkpointer;
import org.springframework.integration.metadata.ConcurrentMetadataStore;

class ShardCheckpointer
implements Checkpointer {
    private static final Log logger = LogFactory.getLog(ShardCheckpointer.class);
    private final ConcurrentMetadataStore checkpointStore;
    private final String key;
    private volatile String lastCheckpointValue;
    private volatile boolean active = true;

    ShardCheckpointer(ConcurrentMetadataStore checkpointStore, String key) {
        this.checkpointStore = checkpointStore;
        this.key = key;
    }

    @Override
    public boolean checkpoint() {
        return this.checkpoint(this.lastCheckpointValue);
    }

    @Override
    public boolean checkpoint(String sequenceNumber) {
        if (this.active) {
            String existingSequence = this.getCheckpoint();
            if (existingSequence == null || new BigInteger(existingSequence).compareTo(new BigInteger(sequenceNumber)) < 0) {
                if (existingSequence != null) {
                    return this.checkpointStore.replace(this.key, existingSequence, sequenceNumber);
                }
                return this.checkpointStore.putIfAbsent(this.key, sequenceNumber) == null;
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("The [" + this + "] has been closed. Checkpoints aren't accepted anymore."));
        }
        return false;
    }

    void setHighestSequence(String highestSequence) {
        this.lastCheckpointValue = highestSequence;
    }

    String getCheckpoint() {
        return this.checkpointStore.get(this.key);
    }

    String getLastCheckpointValue() {
        return this.lastCheckpointValue;
    }

    void remove() {
        this.checkpointStore.remove(this.key);
    }

    void close() {
        this.active = false;
    }

    public String toString() {
        return "ShardCheckpointer{key='" + this.key + '\'' + ", lastCheckpointValue='" + this.lastCheckpointValue + '\'' + '}';
    }
}

