/*
 * Copyright 2016-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.context;

import org.springframework.expression.Expression;

/**
 * Components that implement this interface are capable of supporting a primary
 * SpEL expression as part of their configuration.
 *
 * @author Gary Russell
 * @since 4.3
 *
 */
public interface ExpressionCapable {

	/**
	 * Return the primary SpEL expression if this component is expression-based.
	 * @return the expression as a String.
	 */
	Expression getExpression();

}
