/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.kafka.config.MethodKafkaListenerEndpoint;
import org.springframework.kafka.listener.adapter.DelegatingInvocableHandler;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class MultiMethodKafkaListenerEndpoint<K, V>
extends MethodKafkaListenerEndpoint<K, V> {
    private final List<Method> methods;

    public MultiMethodKafkaListenerEndpoint(List<Method> methods, Object bean) {
        this.methods = methods;
        this.setBean(bean);
    }

    @Override
    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter<K, V> messageListener) {
        ArrayList<InvocableHandlerMethod> invocableHandlerMethods = new ArrayList<InvocableHandlerMethod>();
        for (Method method : this.methods) {
            invocableHandlerMethods.add(this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(this.getBean(), method));
        }
        DelegatingInvocableHandler delegatingHandler = new DelegatingInvocableHandler(invocableHandlerMethods, this.getBean(), this.getResolver(), this.getBeanExpressionContext());
        return new HandlerAdapter(delegatingHandler);
    }
}

