/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultKafkaConsumerFactory<K, V>
implements ConsumerFactory<K, V> {
    private final Map<String, Object> configs;
    private Supplier<Deserializer<K>> keyDeserializerSupplier;
    private Supplier<Deserializer<V>> valueDeserializerSupplier;

    public DefaultKafkaConsumerFactory(Map<String, Object> configs) {
        this(configs, () -> null, () -> null);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, @Nullable Deserializer<K> keyDeserializer, @Nullable Deserializer<V> valueDeserializer) {
        this(configs, () -> keyDeserializer, () -> valueDeserializer);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, @Nullable Supplier<Deserializer<K>> keyDeserializerSupplier, @Nullable Supplier<Deserializer<V>> valueDeserializerSupplier) {
        this.configs = new HashMap<String, Object>(configs);
        this.keyDeserializerSupplier = keyDeserializerSupplier == null ? () -> null : keyDeserializerSupplier;
        this.valueDeserializerSupplier = valueDeserializerSupplier == null ? () -> null : valueDeserializerSupplier;
    }

    public void setKeyDeserializer(@Nullable Deserializer<K> keyDeserializer) {
        this.keyDeserializerSupplier = () -> keyDeserializer;
    }

    public void setValueDeserializer(@Nullable Deserializer<V> valueDeserializer) {
        this.valueDeserializerSupplier = () -> valueDeserializer;
    }

    @Override
    public Map<String, Object> getConfigurationProperties() {
        return Collections.unmodifiableMap(this.configs);
    }

    @Override
    public Deserializer<K> getKeyDeserializer() {
        return this.keyDeserializerSupplier.get();
    }

    @Override
    public Deserializer<V> getValueDeserializer() {
        return this.valueDeserializerSupplier.get();
    }

    @Override
    public Consumer<K, V> createConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffix) {
        return this.createKafkaConsumer(groupId, clientIdPrefix, clientIdSuffix, null);
    }

    @Override
    public Consumer<K, V> createConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffixArg, @Nullable Properties properties) {
        return this.createKafkaConsumer(groupId, clientIdPrefix, clientIdSuffixArg, properties);
    }

    @Deprecated
    protected KafkaConsumer<K, V> createKafkaConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffixArg) {
        return this.createKafkaConsumer(groupId, clientIdPrefix, clientIdSuffixArg, null);
    }

    protected KafkaConsumer<K, V> createKafkaConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffixArg, @Nullable Properties properties) {
        boolean shouldModifyClientId;
        boolean overrideClientIdPrefix = StringUtils.hasText((String)clientIdPrefix);
        String clientIdSuffix = clientIdSuffixArg;
        if (clientIdSuffix == null) {
            clientIdSuffix = "";
        }
        boolean bl = shouldModifyClientId = this.configs.containsKey("client.id") && StringUtils.hasText((String)clientIdSuffix) || overrideClientIdPrefix;
        if (!(groupId != null || properties != null && properties.stringPropertyNames().size() != 0 || shouldModifyClientId)) {
            return this.createKafkaConsumer(this.configs);
        }
        return this.createConsumerWithAdjustedProperties(groupId, clientIdPrefix, properties, overrideClientIdPrefix, clientIdSuffix, shouldModifyClientId);
    }

    private KafkaConsumer<K, V> createConsumerWithAdjustedProperties(String groupId, String clientIdPrefix, Properties properties, boolean overrideClientIdPrefix, String clientIdSuffix, boolean shouldModifyClientId) {
        HashMap<String, Object> modifiedConfigs = new HashMap<String, Object>(this.configs);
        if (groupId != null) {
            modifiedConfigs.put("group.id", groupId);
        }
        if (shouldModifyClientId) {
            modifiedConfigs.put("client.id", (overrideClientIdPrefix ? clientIdPrefix : modifiedConfigs.get("client.id")) + clientIdSuffix);
        }
        if (properties != null) {
            properties.stringPropertyNames().stream().filter(name -> !name.equals("client.id") && !name.equals("group.id")).forEach(name -> modifiedConfigs.put((String)name, properties.getProperty((String)name)));
        }
        return this.createKafkaConsumer(modifiedConfigs);
    }

    protected KafkaConsumer<K, V> createKafkaConsumer(Map<String, Object> configProps) {
        return new KafkaConsumer(configProps, this.keyDeserializerSupplier.get(), this.valueDeserializerSupplier.get());
    }

    @Override
    public boolean isAutoCommit() {
        Object auto = this.configs.get("enable.auto.commit");
        return auto instanceof Boolean ? (Boolean)auto : (auto instanceof String ? Boolean.valueOf((String)auto) : true);
    }
}

