/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.kafka.listener.KafkaExceptionLogLevelAware;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.Assert;

public abstract class ExceptionClassifier
extends KafkaExceptionLogLevelAware {
    private ExtendedBinaryExceptionClassifier classifier = ExceptionClassifier.configureDefaultClassifier();

    private static ExtendedBinaryExceptionClassifier configureDefaultClassifier() {
        HashMap<Class<? extends Throwable>, Boolean> classified = new HashMap<Class<? extends Throwable>, Boolean>();
        classified.put(DeserializationException.class, false);
        classified.put(MessageConversionException.class, false);
        classified.put(ConversionException.class, false);
        classified.put(MethodArgumentResolutionException.class, false);
        classified.put(NoSuchMethodException.class, false);
        classified.put(ClassCastException.class, false);
        return new ExtendedBinaryExceptionClassifier(classified, true);
    }

    public void defaultFalse() {
        this.classifier = new ExtendedBinaryExceptionClassifier(new HashMap<Class<? extends Throwable>, Boolean>(), false);
    }

    protected BinaryExceptionClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifications(Map<Class<? extends Throwable>, Boolean> classifications, boolean defaultValue) {
        Assert.notNull(classifications, (String)"'classifications' + cannot be null");
        this.classifier = new ExtendedBinaryExceptionClassifier(classifications, defaultValue);
    }

    @SafeVarargs
    public final void addNotRetryableExceptions(Class<? extends Exception> ... exceptionTypes) {
        this.add(false, exceptionTypes);
        this.notRetryable(Arrays.stream(exceptionTypes));
    }

    protected void notRetryable(Stream<Class<? extends Exception>> notRetryable) {
    }

    @SafeVarargs
    public final void addRetryableExceptions(Class<? extends Exception> ... exceptionTypes) {
        this.add(true, exceptionTypes);
    }

    @SafeVarargs
    private final void add(boolean classified, Class<? extends Exception> ... exceptionTypes) {
        Assert.notNull(exceptionTypes, (String)"'exceptionTypes' cannot be null");
        Assert.noNullElements((Object[])exceptionTypes, (String)"'exceptionTypes' cannot contain nulls");
        for (Class<? extends Exception> exceptionType : exceptionTypes) {
            Assert.isTrue((boolean)Exception.class.isAssignableFrom(exceptionType), () -> "exceptionType " + exceptionType + " must be an Exception");
            this.classifier.getClassified().put(exceptionType, classified);
        }
    }

    @Deprecated
    public boolean removeNotRetryableException(Class<? extends Exception> exceptionType) {
        return Boolean.TRUE.equals(this.removeClassification(exceptionType));
    }

    @Nullable
    public Boolean removeClassification(Class<? extends Exception> exceptionType) {
        return this.classifier.getClassified().remove(exceptionType);
    }

    private static final class ExtendedBinaryExceptionClassifier
    extends BinaryExceptionClassifier {
        ExtendedBinaryExceptionClassifier(Map<Class<? extends Throwable>, Boolean> typeMap, boolean defaultValue) {
            super(typeMap, defaultValue);
            this.setTraverseCauses(true);
        }

        protected Map<Class<? extends Throwable>, Boolean> getClassified() {
            return super.getClassified();
        }
    }
}

