/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ConfigurerUtils;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenIntrospectionAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2TokenIntrospectionEndpointFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OAuth2TokenIntrospectionEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private AuthenticationConverter introspectionRequestConverter;
    private final List<AuthenticationProvider> authenticationProviders = new LinkedList<AuthenticationProvider>();
    private AuthenticationSuccessHandler introspectionResponseHandler;
    private AuthenticationFailureHandler errorResponseHandler;

    OAuth2TokenIntrospectionEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OAuth2TokenIntrospectionEndpointConfigurer introspectionRequestConverter(AuthenticationConverter introspectionRequestConverter) {
        this.introspectionRequestConverter = introspectionRequestConverter;
        return this;
    }

    public OAuth2TokenIntrospectionEndpointConfigurer authenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider cannot be null");
        this.authenticationProviders.add(authenticationProvider);
        return this;
    }

    public OAuth2TokenIntrospectionEndpointConfigurer introspectionResponseHandler(AuthenticationSuccessHandler introspectionResponseHandler) {
        this.introspectionResponseHandler = introspectionResponseHandler;
        return this;
    }

    public OAuth2TokenIntrospectionEndpointConfigurer errorResponseHandler(AuthenticationFailureHandler errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void init(B builder) {
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        this.requestMatcher = new AntPathRequestMatcher(providerSettings.getTokenIntrospectionEndpoint(), HttpMethod.POST.name());
        List<AuthenticationProvider> authenticationProviders = !this.authenticationProviders.isEmpty() ? this.authenticationProviders : this.createDefaultAuthenticationProviders(builder);
        authenticationProviders.forEach(authenticationProvider -> builder.authenticationProvider(this.postProcess(authenticationProvider)));
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void configure(B builder) {
        AuthenticationManager authenticationManager = (AuthenticationManager)builder.getSharedObject(AuthenticationManager.class);
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        OAuth2TokenIntrospectionEndpointFilter introspectionEndpointFilter = new OAuth2TokenIntrospectionEndpointFilter(authenticationManager, providerSettings.getTokenIntrospectionEndpoint());
        if (this.introspectionRequestConverter != null) {
            introspectionEndpointFilter.setAuthenticationConverter(this.introspectionRequestConverter);
        }
        if (this.introspectionResponseHandler != null) {
            introspectionEndpointFilter.setAuthenticationSuccessHandler(this.introspectionResponseHandler);
        }
        if (this.errorResponseHandler != null) {
            introspectionEndpointFilter.setAuthenticationFailureHandler(this.errorResponseHandler);
        }
        builder.addFilterAfter((Filter)this.postProcess(introspectionEndpointFilter), FilterSecurityInterceptor.class);
    }

    @Override
    public RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    private <B extends HttpSecurityBuilder<B>> List<AuthenticationProvider> createDefaultAuthenticationProviders(B builder) {
        ArrayList<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
        OAuth2TokenIntrospectionAuthenticationProvider tokenIntrospectionAuthenticationProvider = new OAuth2TokenIntrospectionAuthenticationProvider(OAuth2ConfigurerUtils.getRegisteredClientRepository(builder), OAuth2ConfigurerUtils.getAuthorizationService(builder));
        authenticationProviders.add(tokenIntrospectionAuthenticationProvider);
        return authenticationProviders;
    }
}

