/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.core.Version;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2AuthorizationCodeRequestAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
    private String authorizationUri;
    private String clientId;
    private Authentication principal;
    private String redirectUri;
    private Set<String> scopes;
    private String state;
    private Map<String, Object> additionalParameters;
    private boolean consentRequired;
    private boolean consent;
    private OAuth2AuthorizationCode authorizationCode;

    private OAuth2AuthorizationCodeRequestAuthenticationToken() {
        super(Collections.emptyList());
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return "";
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public boolean isConsentRequired() {
        return this.consentRequired;
    }

    public boolean isConsent() {
        return this.consent;
    }

    @Nullable
    public OAuth2AuthorizationCode getAuthorizationCode() {
        return this.authorizationCode;
    }

    public static Builder with(@NonNull String clientId, @NonNull Authentication principal) {
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        return new Builder(clientId, principal);
    }

    public static final class Builder
    implements Serializable {
        private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
        private String authorizationUri;
        private String clientId;
        private Authentication principal;
        private String redirectUri;
        private Set<String> scopes;
        private String state;
        private Map<String, Object> additionalParameters;
        private boolean consentRequired;
        private boolean consent;
        private OAuth2AuthorizationCode authorizationCode;

        private Builder(String clientId, Authentication principal) {
            this.clientId = clientId;
            this.principal = principal;
        }

        public Builder authorizationUri(String authorizationUri) {
            this.authorizationUri = authorizationUri;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder scopes(Set<String> scopes) {
            if (scopes != null) {
                this.scopes = new HashSet<String>(scopes);
            }
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder additionalParameters(Map<String, Object> additionalParameters) {
            if (additionalParameters != null) {
                this.additionalParameters = new HashMap<String, Object>(additionalParameters);
            }
            return this;
        }

        public Builder consentRequired(boolean consentRequired) {
            this.consentRequired = consentRequired;
            return this;
        }

        public Builder consent(boolean consent) {
            this.consent = consent;
            return this;
        }

        public Builder authorizationCode(OAuth2AuthorizationCode authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        public OAuth2AuthorizationCodeRequestAuthenticationToken build() {
            Assert.hasText((String)this.authorizationUri, (String)"authorizationUri cannot be empty");
            if (this.consent) {
                Assert.hasText((String)this.state, (String)"state cannot be empty");
            }
            OAuth2AuthorizationCodeRequestAuthenticationToken authentication = new OAuth2AuthorizationCodeRequestAuthenticationToken();
            authentication.authorizationUri = this.authorizationUri;
            authentication.clientId = this.clientId;
            authentication.principal = this.principal;
            authentication.redirectUri = this.redirectUri;
            authentication.scopes = Collections.unmodifiableSet(!CollectionUtils.isEmpty(this.scopes) ? this.scopes : Collections.emptySet());
            authentication.state = this.state;
            authentication.additionalParameters = Collections.unmodifiableMap(!CollectionUtils.isEmpty(this.additionalParameters) ? this.additionalParameters : Collections.emptyMap());
            authentication.consentRequired = this.consentRequired;
            authentication.consent = this.consent;
            authentication.authorizationCode = this.authorizationCode;
            if (this.authorizationCode != null || this.consentRequired) {
                authentication.setAuthenticated(true);
            }
            return authentication;
        }
    }
}

