/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.core.oidc.OidcProviderConfiguration;
import org.springframework.security.oauth2.core.oidc.http.converter.OidcProviderConfigurationHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.context.ProviderContextHolder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public final class OidcProviderConfigurationEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_OIDC_PROVIDER_CONFIGURATION_ENDPOINT_URI = "/.well-known/openid-configuration";
    private final ProviderSettings providerSettings;
    private final RequestMatcher requestMatcher;
    private final OidcProviderConfigurationHttpMessageConverter providerConfigurationHttpMessageConverter = new OidcProviderConfigurationHttpMessageConverter();

    public OidcProviderConfigurationEndpointFilter(ProviderSettings providerSettings) {
        Assert.notNull((Object)providerSettings, (String)"providerSettings cannot be null");
        this.providerSettings = providerSettings;
        this.requestMatcher = new AntPathRequestMatcher(DEFAULT_OIDC_PROVIDER_CONFIGURATION_ENDPOINT_URI, HttpMethod.GET.name());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String issuer = ProviderContextHolder.getProviderContext().getIssuer();
        OidcProviderConfiguration providerConfiguration = ((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)OidcProviderConfiguration.builder().issuer(issuer)).authorizationEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, this.providerSettings.getAuthorizationEndpoint()))).tokenEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, this.providerSettings.getTokenEndpoint()))).tokenEndpointAuthenticationMethods(OidcProviderConfigurationEndpointFilter.clientAuthenticationMethods())).jwkSetUrl(OidcProviderConfigurationEndpointFilter.asUrl(issuer, this.providerSettings.getJwkSetEndpoint()))).userInfoEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, this.providerSettings.getOidcUserInfoEndpoint())).responseType(OAuth2AuthorizationResponseType.CODE.getValue())).grantType(AuthorizationGrantType.AUTHORIZATION_CODE.getValue())).grantType(AuthorizationGrantType.CLIENT_CREDENTIALS.getValue())).grantType(AuthorizationGrantType.REFRESH_TOKEN.getValue())).tokenRevocationEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, this.providerSettings.getTokenRevocationEndpoint()))).tokenRevocationEndpointAuthenticationMethods(OidcProviderConfigurationEndpointFilter.clientAuthenticationMethods())).tokenIntrospectionEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, this.providerSettings.getTokenIntrospectionEndpoint()))).tokenIntrospectionEndpointAuthenticationMethods(OidcProviderConfigurationEndpointFilter.clientAuthenticationMethods())).subjectType("public").idTokenSigningAlgorithm(SignatureAlgorithm.RS256.getName()).scope("openid")).build();
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.providerConfigurationHttpMessageConverter.write(providerConfiguration, MediaType.APPLICATION_JSON, (HttpOutputMessage)httpResponse);
    }

    private static Consumer<List<String>> clientAuthenticationMethods() {
        return authenticationMethods -> {
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_BASIC.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue());
        };
    }

    private static String asUrl(String issuer, String endpoint) {
        return UriComponentsBuilder.fromUriString((String)issuer).path(endpoint).build().toUriString();
    }
}

