/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;

public final class DelegatingOAuth2TokenGenerator
implements OAuth2TokenGenerator<OAuth2Token> {
    private final List<OAuth2TokenGenerator<OAuth2Token>> tokenGenerators;

    @SafeVarargs
    public DelegatingOAuth2TokenGenerator(OAuth2TokenGenerator<? extends OAuth2Token> ... tokenGenerators) {
        Assert.notEmpty((Object[])tokenGenerators, (String)"tokenGenerators cannot be empty");
        Assert.noNullElements((Object[])tokenGenerators, (String)"tokenGenerator cannot be null");
        this.tokenGenerators = Collections.unmodifiableList(DelegatingOAuth2TokenGenerator.asList(tokenGenerators));
    }

    @Override
    @Nullable
    public OAuth2Token generate(OAuth2TokenContext context) {
        for (OAuth2TokenGenerator<OAuth2Token> tokenGenerator : this.tokenGenerators) {
            OAuth2Token token = tokenGenerator.generate(context);
            if (token == null) continue;
            return token;
        }
        return null;
    }

    private static List<OAuth2TokenGenerator<OAuth2Token>> asList(OAuth2TokenGenerator<? extends OAuth2Token> ... tokenGenerators) {
        ArrayList<OAuth2TokenGenerator<OAuth2Token>> tokenGeneratorList = new ArrayList<OAuth2TokenGenerator<OAuth2Token>>();
        for (OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator : tokenGenerators) {
            tokenGeneratorList.add(tokenGenerator);
        }
        return tokenGeneratorList;
    }
}

