/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.context.ProviderContext;
import org.springframework.security.oauth2.server.authorization.context.ProviderContextHolder;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public final class ProviderContextFilter
extends OncePerRequestFilter {
    private final ProviderSettings providerSettings;

    public ProviderContextFilter(ProviderSettings providerSettings) {
        Assert.notNull((Object)providerSettings, (String)"providerSettings cannot be null");
        this.providerSettings = providerSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            ProviderContext providerContext = new ProviderContext(this.providerSettings, () -> ProviderContextFilter.resolveIssuer(this.providerSettings, request));
            ProviderContextHolder.setProviderContext(providerContext);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            ProviderContextHolder.resetProviderContext();
        }
    }

    private static String resolveIssuer(ProviderSettings providerSettings, HttpServletRequest request) {
        return providerSettings.getIssuer() != null ? providerSettings.getIssuer() : ProviderContextFilter.getContextPath(request);
    }

    private static String getContextPath(HttpServletRequest request) {
        return UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build().toUriString();
    }
}

