/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.oauth2.core.oidc.StandardClaimAccessor;
import org.springframework.util.Assert;

public class OidcUserInfo
implements StandardClaimAccessor,
Serializable {
    private static final long serialVersionUID = 510L;
    private final Map<String, Object> claims;

    public OidcUserInfo(Map<String, Object> claims) {
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OidcUserInfo that = (OidcUserInfo)obj;
        return this.getClaims().equals(that.getClaims());
    }

    public int hashCode() {
        return this.getClaims().hashCode();
    }
}

