/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context.support;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.test.context.support.WithMockUser;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class WithMockUserSecurityContextFactory
implements WithSecurityContextFactory<WithMockUser> {
    WithMockUserSecurityContextFactory() {
    }

    @Override
    public SecurityContext createSecurityContext(WithMockUser withUser) {
        String username = StringUtils.hasLength((String)withUser.username()) ? withUser.username() : withUser.value();
        Assert.notNull((Object)username, () -> withUser + " cannot have null username on both username and value properties");
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        for (String authority : withUser.authorities()) {
            grantedAuthorities.add(new SimpleGrantedAuthority(authority));
        }
        if (grantedAuthorities.isEmpty()) {
            for (String role : withUser.roles()) {
                Assert.isTrue((!role.startsWith("ROLE_") ? 1 : 0) != 0, () -> "roles cannot start with ROLE_ Got " + role);
                grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_" + role));
            }
        } else if (withUser.roles().length != 1 || !"USER".equals(withUser.roles()[0])) {
            throw new IllegalStateException("You cannot define roles attribute " + Arrays.asList(withUser.roles()) + " with authorities attribute " + Arrays.asList(withUser.authorities()));
        }
        User principal = new User(username, withUser.password(), true, true, true, true, grantedAuthorities);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)principal.getPassword(), principal.getAuthorities());
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication((Authentication)authentication);
        return context;
    }
}

