/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.shell.command.CommandRegistration;

public class CommandNotFound
extends RuntimeException {
    private final List<String> words;
    private final Map<String, CommandRegistration> registrations;
    private final String text;

    public CommandNotFound(List<String> words) {
        this(words, null, null);
    }

    public CommandNotFound(List<String> words, Map<String, CommandRegistration> registrations, String text) {
        this.words = words;
        this.registrations = registrations;
        this.text = text;
    }

    @Override
    public String getMessage() {
        return String.format("No command found for '%s'", this.words.stream().collect(Collectors.joining(" ")));
    }

    public List<String> getWords() {
        return new ArrayList<String>(this.words);
    }

    public Map<String, CommandRegistration> getRegistrations() {
        return this.registrations;
    }

    public String getText() {
        return this.text;
    }
}

