/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.shell.ShellApplicationRunner;
import org.springframework.shell.ShellRunner;

@Order(value=0)
public class DefaultShellApplicationRunner
implements ShellApplicationRunner {
    public static final int PRECEDENCE = 0;
    private static final Logger log = LoggerFactory.getLogger(DefaultShellApplicationRunner.class);
    private final List<ShellRunner> shellRunners;

    public DefaultShellApplicationRunner(List<ShellRunner> shellRunners) {
        Collections.sort(shellRunners, new AnnotationAwareOrderComparator());
        this.shellRunners = shellRunners;
    }

    public void run(ApplicationArguments args) throws Exception {
        ShellRunner runner;
        log.debug("Checking shell runners {}", this.shellRunners);
        String[] sourceArgs = args.getSourceArgs();
        boolean canRun = false;
        Iterator<ShellRunner> iterator = this.shellRunners.iterator();
        while (iterator.hasNext() && !(canRun = (runner = iterator.next()).run(sourceArgs))) {
        }
        if (canRun) {
            return;
        }
        Optional<ShellRunner> optional = this.shellRunners.stream().filter(sh -> sh.canRun(args)).findFirst();
        ShellRunner shellRunner = optional.orElse(null);
        log.debug("Using shell runner {}", (Object)shellRunner);
        if (shellRunner != null) {
            shellRunner.run(args);
        }
    }
}

