/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.MethodParameter;

public class ValueResult {
    private final MethodParameter methodParameter;
    private final Object resolvedValue;
    private final BitSet wordsUsed;
    private final BitSet wordsUsedForValue;

    public ValueResult(MethodParameter methodParameter, Object resolvedValue) {
        this(methodParameter, resolvedValue, new BitSet(), new BitSet());
    }

    public ValueResult(MethodParameter methodParameter, Object resolvedValue, BitSet wordsUsed, BitSet wordsUsedForValue) {
        this.methodParameter = methodParameter;
        this.resolvedValue = resolvedValue;
        this.wordsUsed = wordsUsed == null ? new BitSet() : wordsUsed;
        this.wordsUsedForValue = wordsUsedForValue == null ? new BitSet() : wordsUsedForValue;
    }

    public MethodParameter methodParameter() {
        return this.methodParameter;
    }

    public Object resolvedValue() {
        return this.resolvedValue;
    }

    public BitSet wordsUsed() {
        return this.wordsUsed;
    }

    public BitSet wordsUsedForValue() {
        return this.wordsUsedForValue;
    }

    public List<String> wordsUsed(List<String> words) {
        return this.wordsUsed.stream().mapToObj(index -> (String)words.get(index)).collect(Collectors.toList());
    }

    public List<String> wordsUsedForValue(List<String> words) {
        return this.wordsUsedForValue.stream().mapToObj(index -> (String)words.get(index)).collect(Collectors.toList());
    }
}

