/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.shell.command.CommandAlias;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.CommandResolver;
import org.springframework.shell.context.InteractionMode;
import org.springframework.shell.context.ShellContext;

public interface CommandCatalog {
    public void register(CommandRegistration ... var1);

    public void unregister(CommandRegistration ... var1);

    public void unregister(String ... var1);

    public Map<String, CommandRegistration> getRegistrations();

    public static CommandCatalog of() {
        return new DefaultCommandCatalog(null, null);
    }

    public static CommandCatalog of(Collection<CommandResolver> resolvers, ShellContext shellContext) {
        return new DefaultCommandCatalog(resolvers, shellContext);
    }

    public static class DefaultCommandCatalog
    implements CommandCatalog {
        private final Map<String, CommandRegistration> commandRegistrations = new HashMap<String, CommandRegistration>();
        private final Collection<CommandResolver> resolvers = new ArrayList<CommandResolver>();
        private final ShellContext shellContext;

        DefaultCommandCatalog(Collection<CommandResolver> resolvers, ShellContext shellContext) {
            this.shellContext = shellContext;
            if (resolvers != null) {
                this.resolvers.addAll(resolvers);
            }
        }

        @Override
        public void register(CommandRegistration ... registration) {
            for (CommandRegistration r : registration) {
                String commandName = r.getCommand();
                this.commandRegistrations.put(commandName, r);
                for (CommandAlias a : r.getAliases()) {
                    this.commandRegistrations.put(a.getCommand(), r);
                }
            }
        }

        @Override
        public void unregister(CommandRegistration ... registration) {
            for (CommandRegistration r : registration) {
                String commandName = r.getCommand();
                this.commandRegistrations.remove(commandName);
                for (CommandAlias a : r.getAliases()) {
                    this.commandRegistrations.remove(a.getCommand());
                }
            }
        }

        @Override
        public void unregister(String ... commandName) {
            for (String n : commandName) {
                this.commandRegistrations.remove(n);
            }
        }

        @Override
        public Map<String, CommandRegistration> getRegistrations() {
            HashMap<String, CommandRegistration> regs = new HashMap<String, CommandRegistration>();
            regs.putAll(this.commandRegistrations);
            for (CommandResolver resolver : this.resolvers) {
                resolver.resolve().stream().forEach(r -> regs.put(r.getCommand(), (CommandRegistration)r));
            }
            return regs.entrySet().stream().filter(DefaultCommandCatalog.filterByInteractionMode(this.shellContext)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private static Predicate<Map.Entry<String, CommandRegistration>> filterByInteractionMode(ShellContext shellContext) {
            return e -> {
                InteractionMode cim;
                InteractionMode mim = ((CommandRegistration)e.getValue()).getInteractionMode();
                InteractionMode interactionMode = cim = shellContext != null ? shellContext.getInteractionMode() : InteractionMode.ALL;
                if (mim == null || cim == null || mim == InteractionMode.ALL) {
                    return true;
                }
                if (mim == InteractionMode.INTERACTIVE) {
                    return cim == InteractionMode.INTERACTIVE || cim == InteractionMode.ALL;
                }
                if (mim == InteractionMode.NONINTERACTIVE) {
                    return cim == InteractionMode.NONINTERACTIVE || cim == InteractionMode.ALL;
                }
                return true;
            };
        }
    }
}

