/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import jakarta.validation.Validator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jline.terminal.Terminal;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.shell.Availability;
import org.springframework.shell.CommandNotCurrentlyAvailable;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.shell.command.CommandContext;
import org.springframework.shell.command.CommandParser;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.invocation.InvocableShellMethod;
import org.springframework.shell.command.invocation.ShellMethodArgumentResolverComposite;
import org.springframework.shell.command.parser.ParserConfig;
import org.springframework.shell.context.ShellContext;
import org.springframework.util.ObjectUtils;

public interface CommandExecution {
    public Object evaluate(String[] var1);

    public static CommandExecution of(List<? extends HandlerMethodArgumentResolver> resolvers) {
        return new DefaultCommandExecution(resolvers, null, null, null, null, null);
    }

    public static CommandExecution of(List<? extends HandlerMethodArgumentResolver> resolvers, Validator validator, Terminal terminal, ShellContext shellContext, ConversionService conversionService) {
        return new DefaultCommandExecution(resolvers, validator, terminal, shellContext, conversionService, null);
    }

    public static CommandExecution of(List<? extends HandlerMethodArgumentResolver> resolvers, Validator validator, Terminal terminal, ShellContext shellContext, ConversionService conversionService, CommandCatalog commandCatalog) {
        return new DefaultCommandExecution(resolvers, validator, terminal, shellContext, conversionService, commandCatalog);
    }

    public static class DefaultCommandExecution
    implements CommandExecution {
        private List<? extends HandlerMethodArgumentResolver> resolvers;
        private Validator validator;
        private Terminal terminal;
        private ShellContext shellContext;
        private ConversionService conversionService;
        private CommandCatalog commandCatalog;

        public DefaultCommandExecution(List<? extends HandlerMethodArgumentResolver> resolvers, Validator validator, Terminal terminal, ShellContext shellContext, ConversionService conversionService, CommandCatalog commandCatalog) {
            this.resolvers = resolvers;
            this.validator = validator;
            this.terminal = terminal;
            this.shellContext = shellContext;
            this.conversionService = conversionService;
            this.commandCatalog = commandCatalog;
        }

        @Override
        public Object evaluate(String[] args) {
            CommandRegistration usedRegistration;
            CommandParser parser = CommandParser.of(this.conversionService, this.commandCatalog.getRegistrations(), new ParserConfig());
            CommandParser.CommandParserResults results = parser.parse(args);
            CommandRegistration registration = results.registration();
            Availability availability = registration.getAvailability();
            if (availability != null && !availability.isAvailable()) {
                return new CommandNotCurrentlyAvailable(registration.getCommand(), availability);
            }
            boolean handleHelpOption = false;
            CommandRegistration.HelpOptionInfo helpOption = registration.getHelpOption();
            if (!(!helpOption.isEnabled() || helpOption.getCommand() == null || ObjectUtils.isEmpty((Object[])helpOption.getLongNames()) && ObjectUtils.isEmpty((Object[])helpOption.getShortNames()))) {
                handleHelpOption = results.results().stream().filter(cpr -> {
                    boolean present = false;
                    if (helpOption.getLongNames() != null) {
                        present = Arrays.asList(cpr.option().getLongNames()).stream().filter(ln -> ObjectUtils.containsElement((Object[])helpOption.getLongNames(), (Object)ln)).findFirst().isPresent();
                    }
                    if (present) {
                        return true;
                    }
                    if (helpOption.getShortNames() != null) {
                        present = Arrays.asList(cpr.option().getShortNames()).stream().filter(sn -> ObjectUtils.containsElement((Object[])helpOption.getShortNames(), (Object)sn)).findFirst().isPresent();
                    }
                    return present;
                }).findFirst().isPresent();
            }
            if (handleHelpOption) {
                CommandParser.CommandParserResults helpResults;
                String command = registration.getCommand();
                CommandParser helpParser = CommandParser.of(this.conversionService, this.commandCatalog.getRegistrations(), new ParserConfig());
                CommandRegistration helpCommandRegistration = this.commandCatalog.getRegistrations().get(registration.getHelpOption().getCommand());
                results = helpResults = helpParser.parse(new String[]{"help", "--command", command});
                usedRegistration = helpCommandRegistration;
            } else {
                usedRegistration = registration;
            }
            if (!results.errors().isEmpty()) {
                throw new CommandParserExceptionsException("Command parser resulted errors", results.errors());
            }
            CommandContext ctx = CommandContext.of(args, results, this.terminal, usedRegistration, this.shellContext);
            Object res = null;
            CommandRegistration.TargetInfo targetInfo = usedRegistration.getTarget();
            if (targetInfo.getTargetType() == CommandRegistration.TargetInfo.TargetType.FUNCTION) {
                res = targetInfo.getFunction().apply(ctx);
            } else if (targetInfo.getTargetType() == CommandRegistration.TargetInfo.TargetType.CONSUMER) {
                targetInfo.getConsumer().accept(ctx);
            } else if (targetInfo.getTargetType() == CommandRegistration.TargetInfo.TargetType.METHOD) {
                try {
                    MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)args);
                    HashMap<String, Object> paramValues = new HashMap<String, Object>();
                    results.results().stream().forEach(r -> {
                        if (r.option().getLongNames() != null) {
                            for (String string : r.option().getLongNames()) {
                                messageBuilder.setHeader("springShellArgument." + (String)string, r.value());
                                paramValues.put(string, r.value());
                            }
                            for (String string : r.option().getLongNamesModified()) {
                                messageBuilder.setHeader("springShellArgument." + (String)string, r.value());
                                paramValues.put(string, r.value());
                            }
                        }
                        if (r.option().getShortNames() != null) {
                            for (Character c : r.option().getShortNames()) {
                                messageBuilder.setHeader("springShellArgument." + c.toString(), r.value());
                            }
                        }
                    });
                    messageBuilder.setHeader("springShellCommandContext", (Object)ctx);
                    InvocableShellMethod invocableShellMethod = new InvocableShellMethod(targetInfo.getBean(), targetInfo.getMethod());
                    invocableShellMethod.setConversionService(this.conversionService);
                    invocableShellMethod.setValidator(this.validator);
                    ShellMethodArgumentResolverComposite argumentResolvers = new ShellMethodArgumentResolverComposite();
                    if (this.resolvers != null) {
                        argumentResolvers.addResolvers(this.resolvers);
                    }
                    if (!paramValues.isEmpty()) {
                        argumentResolvers.addResolver(new ParamNameHandlerMethodArgumentResolver(paramValues, this.conversionService));
                    }
                    invocableShellMethod.setMessageMethodArgumentResolvers(argumentResolvers);
                    res = invocableShellMethod.invoke(messageBuilder.build(), null);
                }
                catch (Exception e) {
                    throw new CommandExecutionException(e);
                }
            }
            return res;
        }
    }

    public static class CommandExecutionHandlerMethodArgumentResolvers {
        private final List<? extends HandlerMethodArgumentResolver> resolvers;

        public CommandExecutionHandlerMethodArgumentResolvers(List<? extends HandlerMethodArgumentResolver> resolvers) {
            this.resolvers = resolvers;
        }

        public List<? extends HandlerMethodArgumentResolver> getResolvers() {
            return this.resolvers;
        }
    }

    public static class CommandParserExceptionsException
    extends RuntimeException {
        private final List<CommandParser.CommandParserException> parserExceptions;

        public CommandParserExceptionsException(String message, List<CommandParser.CommandParserException> parserExceptions) {
            super(message);
            this.parserExceptions = parserExceptions;
        }

        public static CommandParserExceptionsException of(String message, List<CommandParser.CommandParserException> parserExceptions) {
            return new CommandParserExceptionsException(message, parserExceptions);
        }

        public List<CommandParser.CommandParserException> getParserExceptions() {
            return this.parserExceptions;
        }
    }

    public static class CommandExecutionException
    extends RuntimeException {
        public CommandExecutionException(Throwable cause) {
            super(cause);
        }
    }

    @Order(value=100)
    public static class ParamNameHandlerMethodArgumentResolver
    implements HandlerMethodArgumentResolver {
        private final Map<String, Object> paramValues = new HashMap<String, Object>();
        private final ConversionService conversionService;

        ParamNameHandlerMethodArgumentResolver(Map<String, Object> paramValues, ConversionService conversionService) {
            this.paramValues.putAll(paramValues);
            this.conversionService = conversionService;
        }

        public boolean supportsParameter(MethodParameter parameter) {
            String parameterName = parameter.getParameterName();
            if (parameterName == null) {
                return false;
            }
            Class<?> sourceType = this.paramValues.get(parameterName) != null ? this.paramValues.get(parameterName).getClass() : null;
            return this.paramValues.containsKey(parameterName) && this.conversionService.canConvert(sourceType, parameter.getParameterType());
        }

        public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
            Object source = this.paramValues.get(parameter.getParameterName());
            if (source == null) {
                return null;
            }
            TypeDescriptor sourceType = new TypeDescriptor(ResolvableType.forClass(source.getClass()), null, null);
            TypeDescriptor targetType = new TypeDescriptor(parameter);
            return this.conversionService.convert(source, sourceType, targetType);
        }
    }
}

