/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import org.springframework.lang.Nullable;

public interface CommandHandlingResult {
    @Nullable
    public String message();

    public Integer exitCode();

    public boolean isPresent();

    public boolean isEmpty();

    public static CommandHandlingResult empty() {
        return CommandHandlingResult.of(null);
    }

    public static CommandHandlingResult of(@Nullable String message) {
        return CommandHandlingResult.of(message, null);
    }

    public static CommandHandlingResult of(@Nullable String message, Integer exitCode) {
        return new DefaultHandlingResult(message, exitCode);
    }

    public static class DefaultHandlingResult
    implements CommandHandlingResult {
        private final String message;
        private final Integer exitCode;

        DefaultHandlingResult(String message) {
            this(message, null);
        }

        DefaultHandlingResult(String message, Integer exitCode) {
            this.message = message;
            this.exitCode = exitCode;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public Integer exitCode() {
            return this.exitCode;
        }

        @Override
        public boolean isPresent() {
            return this.message != null || this.exitCode != null;
        }

        @Override
        public boolean isEmpty() {
            return !this.isPresent();
        }
    }
}

