/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import org.springframework.core.ResolvableType;
import org.springframework.shell.completion.CompletionResolver;

public interface CommandOption {
    public String[] getLongNames();

    public String[] getLongNamesModified();

    public Character[] getShortNames();

    public String getDescription();

    public ResolvableType getType();

    public boolean isRequired();

    public String getDefaultValue();

    public int getPosition();

    public int getArityMin();

    public int getArityMax();

    public String getLabel();

    public CompletionResolver getCompletion();

    public static CommandOption of(String[] longNames, Character[] shortNames, String description) {
        return CommandOption.of(longNames, null, shortNames, description, null, false, null, null, null, null, null, null);
    }

    public static CommandOption of(String[] longNames, Character[] shortNames, String description, ResolvableType type) {
        return CommandOption.of(longNames, null, shortNames, description, type, false, null, null, null, null, null, null);
    }

    public static CommandOption of(String[] longNames, String[] longNamesModified, Character[] shortNames, String description, ResolvableType type, boolean required, String defaultValue, Integer position, Integer arityMin, Integer arityMax, String label, CompletionResolver completion) {
        return new DefaultCommandOption(longNames, longNamesModified, shortNames, description, type, required, defaultValue, position, arityMin, arityMax, label, completion);
    }

    public static class DefaultCommandOption
    implements CommandOption {
        private String[] longNames;
        private String[] longNamesModified;
        private Character[] shortNames;
        private String description;
        private ResolvableType type;
        private boolean required;
        private String defaultValue;
        private int position;
        private int arityMin;
        private int arityMax;
        private String label;
        private CompletionResolver completion;

        public DefaultCommandOption(String[] longNames, String[] longNamesModified, Character[] shortNames, String description, ResolvableType type, boolean required, String defaultValue, Integer position, Integer arityMin, Integer arityMax, String label, CompletionResolver completion) {
            this.longNames = longNames != null ? longNames : new String[]{};
            this.longNamesModified = longNamesModified != null ? longNamesModified : new String[]{};
            this.shortNames = shortNames != null ? shortNames : new Character[]{};
            this.description = description;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
            this.position = position != null && position > -1 ? position : -1;
            this.arityMin = arityMin != null ? arityMin : -1;
            this.arityMax = arityMax != null ? arityMax : -1;
            this.label = label;
            this.completion = completion;
        }

        @Override
        public String[] getLongNames() {
            return this.longNames;
        }

        @Override
        public String[] getLongNamesModified() {
            return this.longNamesModified;
        }

        @Override
        public Character[] getShortNames() {
            return this.shortNames;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public ResolvableType getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public int getArityMin() {
            return this.arityMin;
        }

        @Override
        public int getArityMax() {
            return this.arityMax;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public CompletionResolver getCompletion() {
            return this.completion;
        }
    }
}

