/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.shell.command.CommandOption;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.parser.Ast;
import org.springframework.shell.command.parser.CommandModel;
import org.springframework.shell.command.parser.Lexer;
import org.springframework.shell.command.parser.Parser;
import org.springframework.shell.command.parser.ParserConfig;

public interface CommandParser {
    public CommandParserResults parse(String[] var1);

    public static CommandParser of(ConversionService conversionService, Map<String, CommandRegistration> registrations, ParserConfig config) {
        return new AstCommandParser(registrations, config, conversionService);
    }

    public static class AstCommandParser
    implements CommandParser {
        private final Map<String, CommandRegistration> registrations;
        private final ParserConfig configuration;
        private final ConversionService conversionService;

        public AstCommandParser(Map<String, CommandRegistration> registrations, ParserConfig configuration, ConversionService conversionService) {
            this.registrations = registrations;
            this.configuration = configuration;
            this.conversionService = conversionService;
        }

        @Override
        public CommandParserResults parse(String[] args) {
            CommandModel commandModel = new CommandModel(this.registrations, this.configuration);
            Lexer.DefaultLexer lexer = new Lexer.DefaultLexer(commandModel, this.configuration);
            Ast.DefaultAst ast = new Ast.DefaultAst();
            Parser.DefaultParser parser = new Parser.DefaultParser(commandModel, lexer, ast, this.configuration, this.conversionService);
            Parser.ParseResult result = parser.parse(Arrays.asList(args));
            ArrayList<CommandParserResult> results = new ArrayList<CommandParserResult>();
            ArrayList<String> positional = new ArrayList<String>();
            ArrayList<CommandParserException> errors = new ArrayList<CommandParserException>();
            result.optionResults().forEach(or -> results.add(CommandParserResult.of(or.option(), or.value())));
            result.messageResults().forEach(mr -> errors.add(new CommandParserException(mr.getMessage())));
            result.argumentResults().forEach(ar -> positional.add(ar.value()));
            return new DefaultCommandParserResults(result.commandRegistration(), results, positional, errors);
        }
    }

    public static class CommandParserException
    extends RuntimeException {
        public CommandParserException(String message) {
            super(message);
        }

        public CommandParserException(String message, Throwable cause) {
            super(message, cause);
        }

        public static CommandParserException of(String message) {
            return new CommandParserException(message);
        }
    }

    public static class DefaultCommandParserResult
    implements CommandParserResult {
        private CommandOption option;
        private Object value;

        DefaultCommandParserResult(CommandOption option, Object value) {
            this.option = option;
            this.value = value;
        }

        @Override
        public CommandOption option() {
            return this.option;
        }

        @Override
        public Object value() {
            return this.value;
        }
    }

    public static class DefaultCommandParserResults
    implements CommandParserResults {
        private CommandRegistration registration;
        private List<CommandParserResult> results;
        private List<String> positional;
        private List<CommandParserException> errors;

        DefaultCommandParserResults(CommandRegistration registration, List<CommandParserResult> results, List<String> positional, List<CommandParserException> errors) {
            this.registration = registration;
            this.results = results;
            this.positional = positional;
            this.errors = errors;
        }

        @Override
        public CommandRegistration registration() {
            return this.registration;
        }

        @Override
        public List<CommandParserResult> results() {
            return this.results;
        }

        @Override
        public List<String> positional() {
            return this.positional;
        }

        @Override
        public List<CommandParserException> errors() {
            return this.errors;
        }
    }

    public static interface CommandParserResults {
        public CommandRegistration registration();

        public List<CommandParserResult> results();

        public List<String> positional();

        public List<CommandParserException> errors();

        public static CommandParserResults of(CommandRegistration registration, List<CommandParserResult> results, List<String> positional, List<CommandParserException> errors) {
            return new DefaultCommandParserResults(registration, results, positional, errors);
        }
    }

    public static interface CommandParserResult {
        public CommandOption option();

        public Object value();

        public static CommandParserResult of(CommandOption option, Object value) {
            return new DefaultCommandParserResult(option, value);
        }
    }
}

