/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.shell.Availability;
import org.springframework.shell.command.CommandAlias;
import org.springframework.shell.command.CommandContext;
import org.springframework.shell.command.CommandExceptionResolver;
import org.springframework.shell.command.CommandExitCode;
import org.springframework.shell.command.CommandOption;
import org.springframework.shell.completion.CompletionResolver;
import org.springframework.shell.context.InteractionMode;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public interface CommandRegistration {
    public String getCommand();

    public InteractionMode getInteractionMode();

    public String getGroup();

    public boolean isHidden();

    public String getDescription();

    public Availability getAvailability();

    public TargetInfo getTarget();

    public List<CommandOption> getOptions();

    public List<CommandAlias> getAliases();

    public CommandExitCode getExitCode();

    public List<CommandExceptionResolver> getExceptionResolvers();

    public HelpOptionInfo getHelpOption();

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static class DefaultBuilder
    extends BaseBuilder {
    }

    public static abstract class BaseBuilder
    implements Builder {
        private String[] commands;
        private InteractionMode interactionMode = InteractionMode.ALL;
        private String group;
        private boolean hidden;
        private String description;
        private Supplier<Availability> availability;
        private List<DefaultOptionSpec> optionSpecs = new ArrayList<DefaultOptionSpec>();
        private List<DefaultAliasSpec> aliasSpecs = new ArrayList<DefaultAliasSpec>();
        private DefaultTargetSpec targetSpec;
        private DefaultExitCodeSpec exitCodeSpec;
        private DefaultErrorHandlingSpec errorHandlingSpec;
        private DefaultHelpOptionsSpec helpOptionsSpec;
        private Function<String, String> defaultOptionNameModifier;

        @Override
        public Builder command(String ... commands) {
            Assert.notNull((Object)commands, (String)"commands must be set");
            this.commands = Arrays.asList(commands).stream().flatMap(c -> Stream.of(c.split(" "))).filter(c -> StringUtils.hasText((String)c)).map(c -> c.trim()).collect(Collectors.toList()).toArray(new String[0]);
            return this;
        }

        @Override
        public Builder interactionMode(InteractionMode mode) {
            this.interactionMode = mode != null ? mode : InteractionMode.ALL;
            return this;
        }

        @Override
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public Builder hidden() {
            return this.hidden(true);
        }

        @Override
        public Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        @Override
        public Builder availability(Supplier<Availability> availability) {
            this.availability = availability;
            return this;
        }

        @Override
        public Builder defaultOptionNameModifier(Function<String, String> modifier) {
            this.defaultOptionNameModifier = modifier;
            return this;
        }

        @Override
        public OptionSpec withOption() {
            DefaultOptionSpec spec = new DefaultOptionSpec(this);
            this.optionSpecs.add(spec);
            return spec;
        }

        @Override
        public TargetSpec withTarget() {
            DefaultTargetSpec spec;
            this.targetSpec = spec = new DefaultTargetSpec(this);
            return spec;
        }

        @Override
        public AliasSpec withAlias() {
            DefaultAliasSpec spec = new DefaultAliasSpec(this);
            this.aliasSpecs.add(spec);
            return spec;
        }

        @Override
        public ExitCodeSpec withExitCode() {
            DefaultExitCodeSpec spec;
            this.exitCodeSpec = spec = new DefaultExitCodeSpec(this);
            return spec;
        }

        @Override
        public ErrorHandlingSpec withErrorHandling() {
            DefaultErrorHandlingSpec spec;
            this.errorHandlingSpec = spec = new DefaultErrorHandlingSpec(this);
            return spec;
        }

        @Override
        public HelpOptionsSpec withHelpOptions() {
            if (this.helpOptionsSpec == null) {
                this.helpOptionsSpec = new DefaultHelpOptionsSpec(this);
            }
            return this.helpOptionsSpec;
        }

        @Override
        public CommandRegistration build() {
            Assert.notNull((Object)this.commands, (String)"command cannot be empty");
            Assert.notNull((Object)this.targetSpec, (String)"target cannot be empty");
            Assert.state((this.targetSpec.bean == null || this.targetSpec.function == null ? 1 : 0) != 0, (String)"only one target can exist");
            return new DefaultCommandRegistration(this.commands, this.interactionMode, this.group, this.hidden, this.description, this.availability, this.optionSpecs, this.targetSpec, this.aliasSpecs, this.exitCodeSpec, this.errorHandlingSpec, this.helpOptionsSpec);
        }
    }

    public static class DefaultCommandRegistration
    implements CommandRegistration {
        private String command;
        private InteractionMode interactionMode;
        private String group;
        private boolean hidden;
        private String description;
        private Supplier<Availability> availability;
        private List<CommandOption> options;
        private List<DefaultOptionSpec> optionSpecs;
        private DefaultTargetSpec targetSpec;
        private List<DefaultAliasSpec> aliasSpecs;
        private DefaultExitCodeSpec exitCodeSpec;
        private DefaultErrorHandlingSpec errorHandlingSpec;
        private DefaultHelpOptionsSpec helpOptionsSpec;

        public DefaultCommandRegistration(String[] commands, InteractionMode interactionMode, String group, boolean hidden, String description, Supplier<Availability> availability, List<DefaultOptionSpec> optionSpecs, DefaultTargetSpec targetSpec, List<DefaultAliasSpec> aliasSpecs, DefaultExitCodeSpec exitCodeSpec, DefaultErrorHandlingSpec errorHandlingSpec, DefaultHelpOptionsSpec helpOptionsSpec) {
            this.command = DefaultCommandRegistration.commandArrayToName(commands);
            this.interactionMode = interactionMode;
            this.group = group;
            this.hidden = hidden;
            this.description = description;
            this.availability = availability;
            this.optionSpecs = optionSpecs;
            this.targetSpec = targetSpec;
            this.aliasSpecs = aliasSpecs;
            this.exitCodeSpec = exitCodeSpec;
            this.errorHandlingSpec = errorHandlingSpec;
            this.helpOptionsSpec = helpOptionsSpec;
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public InteractionMode getInteractionMode() {
            return this.interactionMode;
        }

        @Override
        public String getGroup() {
            return this.group;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Availability getAvailability() {
            return this.availability != null ? this.availability.get() : Availability.available();
        }

        @Override
        public List<CommandOption> getOptions() {
            if (this.options != null) {
                return this.options;
            }
            this.options = this.optionSpecs.stream().map(o -> {
                String[] longNames = o.getLongNames();
                String[] longNamesModified = null;
                Function<String, String> modifier = o.getOptionNameModifier();
                if (modifier != null) {
                    longNamesModified = Arrays.copyOf(longNames, longNames.length);
                    longNames = (String[])Arrays.stream(longNames).map(modifier).toArray(String[]::new);
                }
                return CommandOption.of(longNames, longNamesModified, o.getShortNames(), o.getDescription(), o.getType(), o.isRequired(), o.getDefaultValue(), o.getPosition(), o.getArityMin(), o.getArityMax(), o.getLabel(), o.getCompletion());
            }).collect(Collectors.toList());
            if (this.helpOptionsSpec != null) {
                String[] longNames = this.helpOptionsSpec.longNames != null ? this.helpOptionsSpec.longNames : null;
                Character[] shortNames = this.helpOptionsSpec.shortNames != null ? this.helpOptionsSpec.shortNames : null;
                this.options.add(CommandOption.of(longNames, shortNames, "help for " + this.command, ResolvableType.forType(Void.TYPE)));
            }
            return this.options;
        }

        @Override
        public TargetInfo getTarget() {
            if (this.targetSpec.bean != null) {
                return TargetInfo.of(this.targetSpec.bean, this.targetSpec.method);
            }
            if (this.targetSpec.function != null) {
                return TargetInfo.of(this.targetSpec.function);
            }
            if (this.targetSpec.consumer != null) {
                return TargetInfo.of(this.targetSpec.consumer);
            }
            throw new IllegalArgumentException("No bean, function or consumer defined");
        }

        @Override
        public List<CommandAlias> getAliases() {
            return this.aliasSpecs.stream().map(spec -> CommandAlias.of(DefaultCommandRegistration.commandArrayToName(spec.commands), spec.group)).collect(Collectors.toList());
        }

        @Override
        public CommandExitCode getExitCode() {
            if (this.exitCodeSpec == null) {
                return CommandExitCode.of();
            }
            return CommandExitCode.of(this.exitCodeSpec.functions);
        }

        @Override
        public List<CommandExceptionResolver> getExceptionResolvers() {
            if (this.errorHandlingSpec == null) {
                return Collections.emptyList();
            }
            return this.errorHandlingSpec.resolvers;
        }

        @Override
        public HelpOptionInfo getHelpOption() {
            if (this.helpOptionsSpec == null) {
                return HelpOptionInfo.of();
            }
            return HelpOptionInfo.of(this.helpOptionsSpec.enabled, this.helpOptionsSpec.longNames, this.helpOptionsSpec.shortNames, this.helpOptionsSpec.command);
        }

        private static String commandArrayToName(String[] commands) {
            return Arrays.asList(commands).stream().flatMap(c -> Stream.of(c.split(" "))).filter(c -> StringUtils.hasText((String)c)).map(c -> c.trim()).collect(Collectors.joining(" "));
        }
    }

    public static class DefaultHelpOptionsSpec
    implements HelpOptionsSpec {
        private BaseBuilder builder;
        private String command;
        private String[] longNames;
        private Character[] shortNames;
        private boolean enabled = true;

        DefaultHelpOptionsSpec(BaseBuilder builder) {
            this.builder = builder;
        }

        DefaultHelpOptionsSpec(BaseBuilder otherBuilder, DefaultHelpOptionsSpec otherSpec) {
            this.builder = otherBuilder;
            this.builder.helpOptionsSpec = this;
            this.command = otherSpec.command;
            this.longNames = (String[])otherSpec.longNames.clone();
            this.shortNames = (Character[])otherSpec.shortNames.clone();
            this.enabled = otherSpec.enabled;
        }

        @Override
        public HelpOptionsSpec command(String command) {
            this.command = command;
            return this;
        }

        @Override
        public HelpOptionsSpec longNames(String ... longNames) {
            this.longNames = longNames;
            return this;
        }

        @Override
        public HelpOptionsSpec shortNames(Character ... shortNames) {
            this.shortNames = shortNames;
            return this;
        }

        @Override
        public HelpOptionsSpec enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder and() {
            return this.builder;
        }
    }

    public static class DefaultErrorHandlingSpec
    implements ErrorHandlingSpec {
        private BaseBuilder builder;
        private final List<CommandExceptionResolver> resolvers = new ArrayList<CommandExceptionResolver>();

        DefaultErrorHandlingSpec(BaseBuilder builder) {
            this.builder = builder;
        }

        @Override
        public ErrorHandlingSpec resolver(CommandExceptionResolver resolver) {
            this.resolvers.add(resolver);
            return this;
        }

        @Override
        public Builder and() {
            return this.builder;
        }
    }

    public static class DefaultExitCodeSpec
    implements ExitCodeSpec {
        private BaseBuilder builder;
        private final List<Function<Throwable, Integer>> functions = new ArrayList<Function<Throwable, Integer>>();

        DefaultExitCodeSpec(BaseBuilder builder) {
            this.builder = builder;
        }

        @Override
        public ExitCodeSpec map(Class<? extends Throwable> e, int code) {
            Function<Throwable, Integer> f = t -> {
                if (t != null && ObjectUtils.nullSafeEquals(t.getClass(), (Object)e)) {
                    return code;
                }
                return 0;
            };
            this.functions.add(f);
            return this;
        }

        @Override
        public ExitCodeSpec map(Function<Throwable, Integer> function) {
            this.functions.add(function);
            return this;
        }

        @Override
        public Builder and() {
            return this.builder;
        }
    }

    public static class DefaultAliasSpec
    implements AliasSpec {
        private BaseBuilder builder;
        private String[] commands;
        private String group;

        DefaultAliasSpec(BaseBuilder builder) {
            this.builder = builder;
        }

        @Override
        public AliasSpec command(String ... commands) {
            Assert.notNull((Object)commands, (String)"commands must be set");
            this.commands = Arrays.asList(commands).stream().flatMap(c -> Stream.of(c.split(" "))).filter(c -> StringUtils.hasText((String)c)).map(c -> c.trim()).collect(Collectors.toList()).toArray(new String[0]);
            return this;
        }

        @Override
        public AliasSpec group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public Builder and() {
            return this.builder;
        }
    }

    public static class DefaultTargetSpec
    implements TargetSpec {
        private BaseBuilder builder;
        private Object bean;
        private Method method;
        private Function<CommandContext, ?> function;
        private Consumer<CommandContext> consumer;

        DefaultTargetSpec(BaseBuilder builder) {
            this.builder = builder;
        }

        @Override
        public TargetSpec method(Object bean, Method method) {
            this.bean = bean;
            this.method = method;
            return this;
        }

        @Override
        public TargetSpec method(Object bean, String method, Class<?> ... paramTypes) {
            this.bean = bean;
            this.method = ReflectionUtils.findMethod(bean.getClass(), (String)method, (Class[])(ObjectUtils.isEmpty((Object[])paramTypes) ? null : paramTypes));
            return this;
        }

        @Override
        public TargetSpec function(Function<CommandContext, ?> function) {
            this.function = function;
            return this;
        }

        @Override
        public TargetSpec consumer(Consumer<CommandContext> consumer) {
            this.consumer = consumer;
            return this;
        }

        @Override
        public Builder and() {
            return this.builder;
        }
    }

    public static class DefaultOptionSpec
    implements OptionSpec {
        private BaseBuilder builder;
        private String[] longNames;
        private Character[] shortNames;
        private ResolvableType type;
        private String description;
        private boolean required;
        private String defaultValue;
        private Integer position;
        private Integer arityMin;
        private Integer arityMax;
        private String label;
        private CompletionResolver completion;
        private Function<String, String> optionNameModifier;

        DefaultOptionSpec(BaseBuilder builder) {
            this.builder = builder;
        }

        @Override
        public OptionSpec longNames(String ... names) {
            this.longNames = names;
            return this;
        }

        @Override
        public OptionSpec shortNames(Character ... names) {
            this.shortNames = names;
            return this;
        }

        @Override
        public OptionSpec type(Type type) {
            this.type = ResolvableType.forType((Type)type);
            return this;
        }

        @Override
        public OptionSpec type(ResolvableType type) {
            this.type = type;
            return this;
        }

        @Override
        public OptionSpec description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public OptionSpec required(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public OptionSpec required() {
            return this.required(true);
        }

        @Override
        public OptionSpec defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public OptionSpec position(Integer position) {
            this.position = position;
            return this;
        }

        @Override
        public OptionSpec arity(int min, int max) {
            Assert.isTrue((min > -1 ? 1 : 0) != 0, (String)"arity min must be 0 or more");
            Assert.isTrue((max >= min ? 1 : 0) != 0, (String)"arity max must be equal more than min");
            this.arityMin = min;
            this.arityMax = max;
            return this;
        }

        @Override
        public OptionSpec arity(OptionArity arity) {
            switch (arity) {
                case NONE: {
                    this.arityMin = null;
                    this.arityMax = null;
                    break;
                }
                case ZERO: {
                    this.arityMin = 0;
                    this.arityMax = 0;
                    break;
                }
                case ZERO_OR_ONE: {
                    this.arityMin = 0;
                    this.arityMax = 1;
                    break;
                }
                case EXACTLY_ONE: {
                    this.arityMin = 1;
                    this.arityMax = 1;
                    break;
                }
                case ZERO_OR_MORE: {
                    this.arityMin = 0;
                    this.arityMax = Integer.MAX_VALUE;
                    break;
                }
                case ONE_OR_MORE: {
                    this.arityMin = 1;
                    this.arityMax = Integer.MAX_VALUE;
                    break;
                }
                default: {
                    this.arityMin = null;
                    this.arityMax = null;
                }
            }
            return this;
        }

        @Override
        public OptionSpec label(String label) {
            this.label = label;
            return this;
        }

        @Override
        public OptionSpec completion(CompletionResolver completion) {
            this.completion = completion;
            return this;
        }

        @Override
        public OptionSpec nameModifier(Function<String, String> modifier) {
            this.optionNameModifier = modifier;
            return this;
        }

        @Override
        public Builder and() {
            return this.builder;
        }

        public String[] getLongNames() {
            return this.longNames;
        }

        public Character[] getShortNames() {
            return this.shortNames;
        }

        public ResolvableType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Integer getPosition() {
            return this.position;
        }

        public Integer getArityMin() {
            return this.arityMin;
        }

        public Integer getArityMax() {
            return this.arityMax;
        }

        public String getLabel() {
            return this.label;
        }

        public CompletionResolver getCompletion() {
            return this.completion;
        }

        @Nullable
        public Function<String, String> getOptionNameModifier() {
            if (this.optionNameModifier != null) {
                return this.optionNameModifier;
            }
            if (this.builder.defaultOptionNameModifier != null) {
                return this.builder.defaultOptionNameModifier;
            }
            return null;
        }
    }

    public static interface Builder {
        public Builder command(String ... var1);

        public Builder interactionMode(InteractionMode var1);

        public Builder description(String var1);

        public Builder availability(Supplier<Availability> var1);

        public Builder group(String var1);

        public Builder hidden();

        public Builder hidden(boolean var1);

        public Builder defaultOptionNameModifier(Function<String, String> var1);

        public OptionSpec withOption();

        public TargetSpec withTarget();

        public AliasSpec withAlias();

        public ExitCodeSpec withExitCode();

        public ErrorHandlingSpec withErrorHandling();

        public HelpOptionsSpec withHelpOptions();

        public CommandRegistration build();
    }

    public static interface HelpOptionsSpec {
        public HelpOptionsSpec enabled(boolean var1);

        public HelpOptionsSpec longNames(String ... var1);

        public HelpOptionsSpec shortNames(Character ... var1);

        public HelpOptionsSpec command(String var1);

        public Builder and();
    }

    public static interface HelpOptionInfo {
        public boolean isEnabled();

        public String[] getLongNames();

        public Character[] getShortNames();

        public String getCommand();

        public static HelpOptionInfo of() {
            return HelpOptionInfo.of(false, null, null, null);
        }

        public static HelpOptionInfo of(boolean enabled, String[] longNames, Character[] shortNames, String command) {
            return new DefaultHelpOptionInfo(enabled, longNames, shortNames, command);
        }

        public static class DefaultHelpOptionInfo
        implements HelpOptionInfo {
            private final String command;
            private final String[] longNames;
            private final Character[] shortNames;
            private final boolean enabled;

            public DefaultHelpOptionInfo(boolean enabled, String[] longNames, Character[] shortNames, String command) {
                this.command = command;
                this.longNames = longNames;
                this.shortNames = shortNames;
                this.enabled = enabled;
            }

            @Override
            public boolean isEnabled() {
                return this.enabled;
            }

            @Override
            public String[] getLongNames() {
                return this.longNames;
            }

            @Override
            public Character[] getShortNames() {
                return this.shortNames;
            }

            @Override
            public String getCommand() {
                return this.command;
            }
        }
    }

    public static interface ErrorHandlingSpec {
        public ErrorHandlingSpec resolver(CommandExceptionResolver var1);

        public Builder and();
    }

    public static interface ExitCodeSpec {
        public ExitCodeSpec map(Class<? extends Throwable> var1, int var2);

        public ExitCodeSpec map(Function<Throwable, Integer> var1);

        public Builder and();
    }

    public static interface AliasSpec {
        public AliasSpec command(String ... var1);

        public AliasSpec group(String var1);

        public Builder and();
    }

    public static interface TargetSpec {
        public TargetSpec method(Object var1, String var2, Class<?> ... var3);

        public TargetSpec method(Object var1, Method var2);

        public TargetSpec function(Function<CommandContext, ?> var1);

        public TargetSpec consumer(Consumer<CommandContext> var1);

        public Builder and();
    }

    public static interface TargetInfo {
        public TargetType getTargetType();

        public Object getBean();

        public Method getMethod();

        public Function<CommandContext, ?> getFunction();

        public Consumer<CommandContext> getConsumer();

        public static TargetInfo of(Object bean, Method method) {
            return new DefaultTargetInfo(TargetType.METHOD, bean, method, null, null);
        }

        public static TargetInfo of(Function<CommandContext, ?> function) {
            return new DefaultTargetInfo(TargetType.FUNCTION, null, null, function, null);
        }

        public static TargetInfo of(Consumer<CommandContext> consumer) {
            return new DefaultTargetInfo(TargetType.CONSUMER, null, null, null, consumer);
        }

        public static class DefaultTargetInfo
        implements TargetInfo {
            private final TargetType targetType;
            private final Object bean;
            private final Method method;
            private final Function<CommandContext, ?> function;
            private final Consumer<CommandContext> consumer;

            public DefaultTargetInfo(TargetType targetType, Object bean, Method method, Function<CommandContext, ?> function, Consumer<CommandContext> consumer) {
                this.targetType = targetType;
                this.bean = bean;
                this.method = method;
                this.function = function;
                this.consumer = consumer;
            }

            @Override
            public TargetType getTargetType() {
                return this.targetType;
            }

            @Override
            public Object getBean() {
                return this.bean;
            }

            @Override
            public Method getMethod() {
                return this.method;
            }

            @Override
            public Function<CommandContext, ?> getFunction() {
                return this.function;
            }

            @Override
            public Consumer<CommandContext> getConsumer() {
                return this.consumer;
            }
        }

        public static enum TargetType {
            METHOD,
            FUNCTION,
            CONSUMER;

        }
    }

    public static enum OptionArity {
        NONE,
        ZERO,
        ZERO_OR_ONE,
        EXACTLY_ONE,
        ZERO_OR_MORE,
        ONE_OR_MORE;

    }

    public static interface OptionSpec {
        public OptionSpec longNames(String ... var1);

        public OptionSpec shortNames(Character ... var1);

        public OptionSpec type(Type var1);

        public OptionSpec type(ResolvableType var1);

        public OptionSpec description(String var1);

        public OptionSpec required(boolean var1);

        public OptionSpec required();

        public OptionSpec defaultValue(String var1);

        public OptionSpec position(Integer var1);

        public OptionSpec arity(int var1, int var2);

        public OptionSpec arity(OptionArity var1);

        public OptionSpec label(String var1);

        public OptionSpec completion(CompletionResolver var1);

        public OptionSpec nameModifier(Function<String, String> var1);

        public Builder and();
    }

    @FunctionalInterface
    public static interface OptionNameModifier
    extends Function<String, String> {
    }

    @FunctionalInterface
    public static interface BuilderSupplier
    extends Supplier<Builder> {
    }
}

