/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jline.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.shell.command.CommandExceptionResolver;
import org.springframework.shell.command.CommandHandlingResult;
import org.springframework.shell.command.annotation.ExceptionResolverMethodResolver;
import org.springframework.shell.command.annotation.ExitCode;
import org.springframework.shell.command.invocation.InvocableShellMethod;
import org.springframework.shell.command.invocation.ShellMethodArgumentResolverComposite;
import org.springframework.util.Assert;

public class MethodCommandExceptionResolver
implements CommandExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(MethodCommandExceptionResolver.class);
    private final Object bean;
    private final Terminal terminal;

    public MethodCommandExceptionResolver(Object bean) {
        this(bean, null);
    }

    public MethodCommandExceptionResolver(Object bean, Terminal terminal) {
        Assert.notNull((Object)bean, (String)"Target bean must be set");
        this.bean = bean;
        this.terminal = terminal;
    }

    @Override
    public CommandHandlingResult resolve(Exception ex) {
        try {
            ExceptionResolverMethodResolver resolver = new ExceptionResolverMethodResolver(this.bean.getClass());
            Method exceptionResolverMethod = resolver.resolveMethodByThrowable(ex);
            if (exceptionResolverMethod == null) {
                return null;
            }
            InvocableShellMethod invocable = new InvocableShellMethod(this.bean, exceptionResolverMethod);
            ShellMethodArgumentResolverComposite argumentResolvers = new ShellMethodArgumentResolverComposite();
            argumentResolvers.addResolver(new TerminalResolver());
            invocable.setMessageMethodArgumentResolvers(argumentResolvers);
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            Throwable exToExpose = ex;
            while (exToExpose != null) {
                exceptions.add((Exception)exToExpose);
                Throwable cause = exToExpose.getCause();
                exToExpose = cause != exToExpose ? cause : null;
            }
            Object[] arguments = new Object[exceptions.size() + 1];
            exceptions.toArray(arguments);
            MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)arguments);
            messageBuilder.setHeader("terminal", (Object)this.terminal);
            MethodParameter returnType = invocable.getReturnType();
            Class parameterType = returnType.getParameterType();
            boolean isVoid = Void.TYPE.isAssignableFrom(parameterType);
            Object invoke = invocable.invoke(messageBuilder.build(), arguments);
            Integer ecFromAnn = null;
            ExitCode ecAnn = (ExitCode)AnnotationUtils.findAnnotation((Method)exceptionResolverMethod, ExitCode.class);
            if (ecAnn != null && ecAnn.code() > 0) {
                ecFromAnn = ecAnn.code();
            }
            if (isVoid) {
                if (ecFromAnn != null) {
                    return CommandHandlingResult.of(null, ecFromAnn);
                }
                return CommandHandlingResult.empty();
            }
            if (invoke instanceof CommandHandlingResult) {
                CommandHandlingResult result = (CommandHandlingResult)invoke;
                if (ecFromAnn != null) {
                    return CommandHandlingResult.of(result.message(), ecFromAnn);
                }
                return (CommandHandlingResult)invoke;
            }
            if (invoke instanceof String) {
                String msg = (String)invoke;
                if (ecFromAnn != null) {
                    return CommandHandlingResult.of(msg, ecFromAnn);
                }
                return CommandHandlingResult.of(msg, 1);
            }
        }
        catch (Exception e) {
            log.warn("Failure in @ExceptionResolver", (Throwable)e);
        }
        return null;
    }

    private static class TerminalResolver
    implements HandlerMethodArgumentResolver {
        private TerminalResolver() {
        }

        public boolean supportsParameter(MethodParameter parameter) {
            return Terminal.class.isAssignableFrom(parameter.getParameterType());
        }

        public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
            Terminal terminal = (Terminal)message.getHeaders().get((Object)"terminal", Terminal.class);
            return terminal;
        }
    }
}

