/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.annotation.support;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.shell.context.InteractionMode;
import org.springframework.util.StringUtils;

class CommandAnnotationUtils {
    private static final String COMMAND = "command";
    private static final String ALIAS = "alias";
    private static final String HIDDEN = "hidden";
    private static final String GROUP = "group";
    private static final String DESCRIPTION = "description";
    private static final String INTERACTION_MODE = "interactionMode";

    CommandAnnotationUtils() {
    }

    static boolean deduceHidden(MergedAnnotation<?> left, MergedAnnotation<?> right) {
        Boolean def = right.getDefaultValue(HIDDEN, Boolean.class).orElse(null);
        boolean l = left.getBoolean(HIDDEN);
        boolean r = right.getBoolean(HIDDEN);
        if (def != null) {
            if (def != r) {
                l = r;
            }
        } else {
            l = r;
        }
        return l;
    }

    static String[] deduceCommand(MergedAnnotation<?> left, MergedAnnotation<?> right) {
        return CommandAnnotationUtils.deduceStringArray(COMMAND, left, right);
    }

    static String[][] deduceAlias(MergedAnnotation<?> left, MergedAnnotation<?> right) {
        return CommandAnnotationUtils.deduceStringArrayLeftPrefixes(ALIAS, left, right);
    }

    static String deduceGroup(MergedAnnotation<?> left, MergedAnnotation<?> right) {
        return CommandAnnotationUtils.deduceStringRightOverrides(GROUP, left, right);
    }

    static String deduceDescription(MergedAnnotation<?> left, MergedAnnotation<?> right) {
        return CommandAnnotationUtils.deduceStringRightOverrides(DESCRIPTION, left, right);
    }

    @Nullable
    static InteractionMode deduceInteractionMode(MergedAnnotation<?> left, MergedAnnotation<?> right) {
        InteractionMode mode;
        block2: {
            InteractionMode[] r;
            InteractionMode[] interactionModeArray;
            int n;
            int n2;
            InteractionMode[] l;
            mode = null;
            InteractionMode[] interactionModeArray2 = l = (InteractionMode[])left.getEnumArray(INTERACTION_MODE, InteractionMode.class);
            int n3 = interactionModeArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                InteractionMode m = interactionModeArray2[n2];
                if (InteractionMode.ALL == m) {
                    mode = m;
                    break;
                }
                mode = m;
            }
            if ((n = 0) >= (n2 = (interactionModeArray = (r = (InteractionMode[])right.getEnumArray(INTERACTION_MODE, InteractionMode.class))).length)) break block2;
            InteractionMode m = interactionModeArray[n];
            mode = InteractionMode.ALL == m ? m : m;
        }
        return mode;
    }

    private static String[][] deduceStringArrayLeftPrefixes(String field, MergedAnnotation<?> left, MergedAnnotation<?> right) {
        List prefix = Stream.of(left.getStringArray(field)).flatMap(command -> Stream.of(command.split(" "))).filter(command -> StringUtils.hasText((String)command)).map(command -> command.strip()).collect(Collectors.toList());
        return (String[][])Stream.of(right.getStringArray(field)).map(command -> command.strip()).map(command -> Stream.concat(prefix.stream(), Stream.of(command).filter(c -> StringUtils.hasText((String)c))).collect(Collectors.toList())).map(arr -> (String[])arr.toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
    }

    private static String[] deduceStringArray(String field, MergedAnnotation<?> left, MergedAnnotation<?> right) {
        return (String[])Stream.of(left.getStringArray(field), right.getStringArray(field)).flatMap(commands -> Stream.of(commands)).flatMap(command -> Stream.of(command.split(" "))).filter(command -> StringUtils.hasText((String)command)).map(command -> command.strip()).toArray(String[]::new);
    }

    private static String deduceStringRightOverrides(String field, MergedAnnotation<?> left, MergedAnnotation<?> right) {
        String r = right.getString(field);
        if (StringUtils.hasText((String)r)) {
            return r;
        }
        return left.getString(field);
    }
}

