/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.annotation.support;

import java.lang.reflect.AnnotatedElement;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.shell.command.annotation.Command;
import org.springframework.shell.command.annotation.support.CommandRegistrationFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class CommandRegistrationBeanRegistrar {
    private final BeanDefinitionRegistry registry;
    private final BeanFactory beanFactory;
    private static final ReflectionUtils.MethodFilter COMMAND_METHODS = method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Command.class);

    public CommandRegistrationBeanRegistrar(BeanDefinitionRegistry registry) {
        this.registry = registry;
        this.beanFactory = (BeanFactory)this.registry;
    }

    public void register(Class<?> type) {
        MergedAnnotation annotation = MergedAnnotations.from(type, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(Command.class);
        this.register(type, (MergedAnnotation<Command>)annotation);
    }

    void register(Class<?> type, MergedAnnotation<Command> annotation) {
        String name = type.getName();
        if (!this.containsBeanDefinition(name)) {
            this.registerCommandClassBeanDefinition(name, type, annotation);
        }
        this.scanMethods(type, name, annotation);
    }

    void scanMethods(Class<?> type, String containerBean, MergedAnnotation<Command> classAnnotation) {
        Set methods = MethodIntrospector.selectMethods(type, (ReflectionUtils.MethodFilter)COMMAND_METHODS);
        methods.forEach(m -> {
            Class<?>[] methodParameterTypes;
            String postfix;
            Object name = type.getName();
            String methodName = m.getName();
            if (!this.containsBeanDefinition((String)(name = (String)name + "/" + methodName + (postfix = Stream.of(methodParameterTypes = m.getParameterTypes()).map(clazz -> ClassUtils.getShortName((Class)clazz)).collect(Collectors.joining()))))) {
                this.registerCommandMethodBeanDefinition(type, (String)name, containerBean, methodName, methodParameterTypes);
            }
        });
    }

    private void registerCommandClassBeanDefinition(String beanName, Class<?> type, MergedAnnotation<Command> annotation) {
        Assert.state((boolean)annotation.isPresent(), () -> "No " + Command.class.getSimpleName() + " annotation found on  '" + type.getName() + "'.");
        this.registry.registerBeanDefinition(beanName, this.createCommandClassBeanDefinition(type));
    }

    private void registerCommandMethodBeanDefinition(Class<?> commandBeanType, String commandBeanName, String containerBean, String methodName, Class<?>[] methodParameterTypes) {
        this.registry.registerBeanDefinition(commandBeanName, this.createCommandMethodBeanDefinition(commandBeanType, containerBean, methodName, methodParameterTypes));
    }

    private BeanDefinition createCommandClassBeanDefinition(Class<?> type) {
        RootBeanDefinition definition = new RootBeanDefinition(type);
        return definition;
    }

    private BeanDefinition createCommandMethodBeanDefinition(Class<?> commandBeanType, String commandBeanName, String commandMethodName, Class<?>[] commandMethodParameters) {
        RootBeanDefinition definition = new RootBeanDefinition(CommandRegistrationFactoryBean.class);
        definition.getPropertyValues().add("commandBeanType", commandBeanType);
        definition.getPropertyValues().add("commandBeanName", (Object)commandBeanName);
        definition.getPropertyValues().add("commandMethodName", (Object)commandMethodName);
        definition.getPropertyValues().add("commandMethodParameters", commandMethodParameters);
        return definition;
    }

    private boolean containsBeanDefinition(String name) {
        return this.containsBeanDefinition(this.beanFactory, name);
    }

    private boolean containsBeanDefinition(BeanFactory beanFactory, String name) {
        ListableBeanFactory listableBeanFactory;
        if (beanFactory instanceof ListableBeanFactory && (listableBeanFactory = (ListableBeanFactory)beanFactory).containsBeanDefinition(name)) {
            return true;
        }
        if (beanFactory instanceof HierarchicalBeanFactory) {
            HierarchicalBeanFactory hierarchicalBeanFactory = (HierarchicalBeanFactory)beanFactory;
            return this.containsBeanDefinition(hierarchicalBeanFactory.getParentBeanFactory(), name);
        }
        return false;
    }
}

