/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.annotation.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.shell.Availability;
import org.springframework.shell.AvailabilityProvider;
import org.springframework.shell.Utils;
import org.springframework.shell.command.CommandContext;
import org.springframework.shell.command.CommandExceptionResolver;
import org.springframework.shell.command.CommandHandlingResult;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.annotation.Command;
import org.springframework.shell.command.annotation.CommandAvailability;
import org.springframework.shell.command.annotation.ExceptionResolverMethodResolver;
import org.springframework.shell.command.annotation.Option;
import org.springframework.shell.command.annotation.OptionValues;
import org.springframework.shell.command.annotation.support.CommandAnnotationUtils;
import org.springframework.shell.command.invocation.InvocableShellMethod;
import org.springframework.shell.completion.CompletionProvider;
import org.springframework.shell.context.InteractionMode;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class CommandRegistrationFactoryBean
implements FactoryBean<CommandRegistration>,
ApplicationContextAware,
InitializingBean {
    private final Logger log = LoggerFactory.getLogger(CommandRegistrationFactoryBean.class);
    public static final String COMMAND_BEAN_TYPE = "commandBeanType";
    public static final String COMMAND_BEAN_NAME = "commandBeanName";
    public static final String COMMAND_METHOD_NAME = "commandMethodName";
    public static final String COMMAND_METHOD_PARAMETERS = "commandMethodParameters";
    private ObjectProvider<CommandRegistration.BuilderSupplier> supplier;
    private ApplicationContext applicationContext;
    private Object commandBean;
    private Class<?> commandBeanType;
    private String commandBeanName;
    private String commandMethodName;
    private Class<?>[] commandMethodParameters;

    CommandRegistrationFactoryBean() {
    }

    public CommandRegistration getObject() throws Exception {
        CommandRegistration registration = this.buildRegistration();
        return registration;
    }

    public Class<?> getObjectType() {
        return CommandRegistration.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.commandBean = this.applicationContext.getBean(this.commandBeanName);
        this.supplier = this.applicationContext.getBeanProvider(CommandRegistration.BuilderSupplier.class);
    }

    public void setCommandBeanType(Class<?> commandBeanType) {
        this.commandBeanType = commandBeanType;
    }

    public void setCommandBeanName(String commandBeanName) {
        this.commandBeanName = commandBeanName;
    }

    public void setCommandMethodName(String commandMethodName) {
        this.commandMethodName = commandMethodName;
    }

    public void setCommandMethodParameters(Class<?>[] commandMethodParameters) {
        this.commandMethodParameters = commandMethodParameters;
    }

    private CommandRegistration.Builder getBuilder() {
        return (CommandRegistration.Builder)((CommandRegistration.BuilderSupplier)this.supplier.getIfAvailable(() -> () -> CommandRegistration.builder())).get();
    }

    private CommandRegistration buildRegistration() {
        String[] refs;
        Object avails;
        Method method = ReflectionUtils.findMethod(this.commandBeanType, (String)this.commandMethodName, (Class[])this.commandMethodParameters);
        MergedAnnotation classAnn = MergedAnnotations.from(this.commandBeanType, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(Command.class);
        MergedAnnotation methodAnn = MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(Command.class);
        CommandRegistration.Builder builder = this.getBuilder();
        String[] deduceCommand = CommandAnnotationUtils.deduceCommand(classAnn, methodAnn);
        if (deduceCommand.length == 0) {
            deduceCommand = new String[]{Utils.unCamelify(method.getName())};
        }
        builder.command(deduceCommand);
        String deduceGroup = CommandAnnotationUtils.deduceGroup(classAnn, methodAnn);
        builder.group(deduceGroup);
        boolean deduceHidden = CommandAnnotationUtils.deduceHidden(classAnn, methodAnn);
        builder.hidden(deduceHidden);
        String deduceDescription = CommandAnnotationUtils.deduceDescription(classAnn, methodAnn);
        builder.description(deduceDescription);
        InteractionMode deduceInteractionMode = CommandAnnotationUtils.deduceInteractionMode(classAnn, methodAnn);
        builder.interactionMode(deduceInteractionMode);
        MergedAnnotation caAnn = MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(CommandAvailability.class);
        if (caAnn.isPresent() && !(avails = Stream.of(refs = caAnn.getStringArray("provider")).map(r -> (AvailabilityProvider)this.applicationContext.getBean(r, AvailabilityProvider.class)).collect(Collectors.toList())).isEmpty()) {
            builder.availability(() -> CommandRegistrationFactoryBean.lambda$buildRegistration$3((List)avails));
        }
        String[][] deduceAlias = CommandAnnotationUtils.deduceAlias(classAnn, methodAnn);
        for (String[] a : deduceAlias) {
            builder.withAlias().command(a);
        }
        builder.withTarget().method(this.commandBean, method);
        InvocableHandlerMethod ihm = new InvocableHandlerMethod(this.commandBean, method);
        for (MethodParameter mp : ihm.getMethodParameters()) {
            this.onCommandParameter(mp, builder);
        }
        ExceptionResolverMethodResolver exceptionResolverMethodResolver = new ExceptionResolverMethodResolver(this.commandBean.getClass());
        MethodCommandExceptionResolver methodCommandExceptionResolver = new MethodCommandExceptionResolver();
        methodCommandExceptionResolver.bean = this.commandBean;
        methodCommandExceptionResolver.exceptionResolverMethodResolver = exceptionResolverMethodResolver;
        builder.withErrorHandling().resolver(methodCommandExceptionResolver);
        CommandRegistration registration = builder.build();
        return registration;
    }

    private void onCommandParameter(MethodParameter mp, CommandRegistration.Builder builder) {
        MergedAnnotation optionAnn = MergedAnnotations.from((AnnotatedElement)mp.getParameter(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(Option.class);
        Option so = (Option)mp.getParameterAnnotation(Option.class);
        this.log.debug("Registering with mp='{}' so='{}'", (Object)mp, (Object)so);
        if (so != null) {
            int i;
            ArrayList<String> longNames = new ArrayList<String>();
            ArrayList<Character> shortNames = new ArrayList<Character>();
            for (i = 0; i < so.shortNames().length; ++i) {
                shortNames.add(Character.valueOf(so.shortNames()[i]));
            }
            if (!ObjectUtils.isEmpty((Object[])so.longNames())) {
                for (i = 0; i < so.longNames().length; ++i) {
                    longNames.add(so.longNames()[i]);
                }
            } else {
                mp.initParameterNameDiscovery((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
                String longName = mp.getParameterName();
                Class parameterType = mp.getParameterType();
                if (longName != null) {
                    this.log.debug("Using mp='{}' longName='{}' parameterType='{}'", new Object[]{mp, longName, parameterType});
                    longNames.add(longName);
                }
            }
            if (!longNames.isEmpty() || !shortNames.isEmpty()) {
                String[] providerBeanNames;
                this.log.debug("Registering longNames='{}' shortNames='{}'", longNames, shortNames);
                Class parameterType = mp.getParameterType();
                CommandRegistration.OptionSpec optionSpec = builder.withOption();
                optionSpec.type(parameterType);
                optionSpec.longNames(longNames.toArray(new String[0]));
                optionSpec.shortNames(shortNames.toArray(new Character[0]));
                optionSpec.position(mp.getParameterIndex());
                optionSpec.description(so.description());
                if (StringUtils.hasText((String)so.label())) {
                    optionSpec.label(so.label());
                }
                int arityMin = so.arityMin();
                int arityMax = so.arityMax();
                if (arityMin > -1) {
                    if (arityMax < arityMin) {
                        arityMax = arityMin;
                    }
                } else if (arityMax > -1 && arityMin < 0) {
                    arityMin = 0;
                }
                if (arityMin > -1 && arityMax > -1) {
                    optionSpec.arity(arityMin, arityMax);
                } else if (so.arity() != CommandRegistration.OptionArity.NONE) {
                    optionSpec.arity(so.arity());
                } else if (ClassUtils.isAssignable(Boolean.TYPE, (Class)parameterType)) {
                    optionSpec.arity(CommandRegistration.OptionArity.ZERO_OR_ONE);
                } else if (ClassUtils.isAssignable(Boolean.class, (Class)parameterType)) {
                    optionSpec.arity(CommandRegistration.OptionArity.ZERO_OR_ONE);
                }
                if (StringUtils.hasText((String)so.defaultValue())) {
                    optionSpec.defaultValue(so.defaultValue());
                } else if (ClassUtils.isAssignable(Boolean.TYPE, (Class)parameterType)) {
                    optionSpec.required(false);
                    optionSpec.defaultValue("false");
                } else if (optionAnn.isPresent()) {
                    boolean requiredDeduce = optionAnn.getBoolean("required");
                    optionSpec.required(requiredDeduce);
                }
                OptionValues ovAnn = (OptionValues)mp.getParameterAnnotation(OptionValues.class);
                if (ovAnn != null && (providerBeanNames = ovAnn.provider()).length > 0) {
                    List resolvers = Arrays.stream(providerBeanNames).map(beanName -> (CompletionProvider)this.applicationContext.getBean(beanName, CompletionProvider.class)).collect(Collectors.toList());
                    optionSpec.completion(ctx -> resolvers.stream().flatMap(resolver -> ((List)resolver.apply(ctx)).stream()).collect(Collectors.toList()));
                }
            }
        } else {
            mp.initParameterNameDiscovery((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
            String longName = mp.getParameterName();
            Class parameterType = mp.getParameterType();
            if (ClassUtils.isAssignable((Class)parameterType, CommandContext.class)) {
                return;
            }
            if (longName != null) {
                this.log.debug("Using mp='{}' longName='{}' parameterType='{}'", new Object[]{mp, longName, parameterType});
                CommandRegistration.OptionSpec optionSpec = builder.withOption();
                optionSpec.longNames(longName);
                optionSpec.type(parameterType);
                optionSpec.required();
                optionSpec.position(mp.getParameterIndex());
                if (ClassUtils.isAssignable(Boolean.TYPE, (Class)parameterType)) {
                    optionSpec.arity(CommandRegistration.OptionArity.ZERO_OR_ONE);
                    optionSpec.required(false);
                    optionSpec.defaultValue("false");
                } else if (ClassUtils.isAssignable(Boolean.class, (Class)parameterType)) {
                    optionSpec.arity(CommandRegistration.OptionArity.ZERO_OR_ONE);
                } else {
                    optionSpec.arity(CommandRegistration.OptionArity.EXACTLY_ONE);
                }
            }
        }
    }

    private static /* synthetic */ Availability lambda$buildRegistration$3(List avails) {
        for (AvailabilityProvider avail : avails) {
            Availability a = (Availability)avail.get();
            if (a.isAvailable()) continue;
            return a;
        }
        return Availability.available();
    }

    private static class MethodCommandExceptionResolver
    implements CommandExceptionResolver {
        Object bean;
        ExceptionResolverMethodResolver exceptionResolverMethodResolver;

        private MethodCommandExceptionResolver() {
        }

        @Override
        public CommandHandlingResult resolve(Exception ex) {
            Method exceptionHandlerMethod = this.exceptionResolverMethodResolver.resolveMethodByThrowable(ex);
            if (exceptionHandlerMethod == null) {
                return null;
            }
            InvocableShellMethod invocable = new InvocableShellMethod(this.bean, exceptionHandlerMethod);
            try {
                Object invoke = invocable.invoke(null, ex);
                if (invoke instanceof CommandHandlingResult) {
                    return (CommandHandlingResult)invoke;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

