/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.annotation.support;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.shell.command.annotation.Option;
import org.springframework.shell.support.AbstractArgumentMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OptionMethodArgumentResolver
extends AbstractArgumentMethodArgumentResolver {
    public OptionMethodArgumentResolver(ConversionService conversionService, @Nullable ConfigurableBeanFactory beanFactory) {
        super(conversionService, beanFactory);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(Option.class);
    }

    @Override
    protected AbstractArgumentMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        Option annot = (Option)parameter.getParameterAnnotation(Option.class);
        Assert.state((annot != null ? 1 : 0) != 0, (String)"No Option annotation");
        List<String> names = Arrays.stream(annot != null ? annot.longNames() : new String[]{}).collect(Collectors.toList());
        return new HeaderNamedValueInfo(annot, names);
    }

    @Override
    @Nullable
    protected Object resolveArgumentInternal(MethodParameter parameter, Message<?> message, List<String> names) throws Exception {
        for (String name : names) {
            if (!message.getHeaders().containsKey((Object)("springShellArgument." + name))) continue;
            return message.getHeaders().get((Object)("springShellArgument." + name));
        }
        return null;
    }

    @Override
    protected void handleMissingValue(List<String> headerName, MethodParameter parameter, Message<?> message) {
        throw new MessageHandlingException(message, "Missing headers '" + StringUtils.collectionToCommaDelimitedString(headerName) + "' for method parameter type [" + parameter.getParameterType() + "]");
    }

    private static final class HeaderNamedValueInfo
    extends AbstractArgumentMethodArgumentResolver.NamedValueInfo {
        private HeaderNamedValueInfo(Option annotation, List<String> names) {
            super(names, false, null);
        }
    }
}

