/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.parser;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.command.parser.AstNode;
import org.springframework.shell.command.parser.CommandArgumentNode;
import org.springframework.shell.command.parser.CommandNode;
import org.springframework.shell.command.parser.DirectiveNode;
import org.springframework.shell.command.parser.NodeVisitor;
import org.springframework.shell.command.parser.NonterminalAstNode;
import org.springframework.shell.command.parser.OptionArgumentNode;
import org.springframework.shell.command.parser.OptionNode;
import org.springframework.shell.command.parser.Parser;
import org.springframework.shell.command.parser.TerminalAstNode;

public abstract class AbstractNodeVisitor
implements NodeVisitor {
    private static final Logger log = LoggerFactory.getLogger(AbstractNodeVisitor.class);

    @Override
    public final Parser.ParseResult visit(List<NonterminalAstNode> nonterminalNodes, List<TerminalAstNode> terminalNodes) {
        AstNode node;
        for (NonterminalAstNode ntn : nonterminalNodes) {
            log.debug("visit {}", (Object)ntn);
            if (!(ntn instanceof CommandNode)) continue;
            node = (CommandNode)ntn;
            log.debug("onEnterRootCommandNode {}", (Object)node);
            this.onEnterRootCommandNode((CommandNode)node);
            this.visitChildren((NonterminalAstNode)node);
            log.debug("onExitRootCommandNode {}", (Object)node);
            this.onExitRootCommandNode((CommandNode)node);
        }
        for (TerminalAstNode tn : terminalNodes) {
            if (!(tn instanceof DirectiveNode)) continue;
            node = (DirectiveNode)tn;
            this.enterDirectiveNode((DirectiveNode)node);
            this.exitDirectiveNode((DirectiveNode)node);
        }
        return this.buildResult();
    }

    protected abstract Parser.ParseResult buildResult();

    protected abstract void onEnterRootCommandNode(CommandNode var1);

    protected abstract void onExitRootCommandNode(CommandNode var1);

    protected abstract void onEnterCommandNode(CommandNode var1);

    protected abstract void onExitCommandNode(CommandNode var1);

    protected abstract void onEnterOptionNode(OptionNode var1);

    protected abstract void onExitOptionNode(OptionNode var1);

    protected abstract void onEnterCommandArgumentNode(CommandArgumentNode var1);

    protected abstract void onExitCommandArgumentNode(CommandArgumentNode var1);

    protected abstract void onEnterOptionArgumentNode(OptionArgumentNode var1);

    protected abstract void onExitOptionArgumentNode(OptionArgumentNode var1);

    protected abstract void onEnterDirectiveNode(DirectiveNode var1);

    protected abstract void onExitDirectiveNode(DirectiveNode var1);

    private void visitChildren(NonterminalAstNode node) {
        log.debug("visitChildren {}", (Object)node);
        for (AstNode syntaxNode : node.getChildren()) {
            this.visitInternal(syntaxNode);
        }
    }

    private void enterCommandNode(CommandNode node) {
        log.debug("enterCommandNode {}", (Object)node);
        this.onEnterCommandNode(node);
    }

    private void exitCommandNode(CommandNode node) {
        log.debug("exitCommandNode {}", (Object)node);
        this.onExitCommandNode(node);
    }

    private void enterOptionNode(OptionNode node) {
        log.debug("enterOptionNode {}", (Object)node);
        this.onEnterOptionNode(node);
    }

    private void exitOptionNode(OptionNode node) {
        log.debug("exitOptionNode {}", (Object)node);
        this.onExitOptionNode(node);
    }

    private void enterCommandArgumentNode(CommandArgumentNode node) {
        log.debug("enterCommandArgumentNode {}", (Object)node);
        this.onEnterCommandArgumentNode(node);
    }

    private void exitCommandArgumentNode(CommandArgumentNode node) {
        log.debug("exitCommandArgumentNode {}", (Object)node);
        this.onExitCommandArgumentNode(node);
    }

    private void enterOptionArgumentNode(OptionArgumentNode node) {
        log.debug("enterOptionArgumentNode {}", (Object)node);
        this.onEnterOptionArgumentNode(node);
    }

    private void exitOptionArgumentNode(OptionArgumentNode node) {
        log.debug("exitOptionArgumentNode {}", (Object)node);
        this.onExitOptionArgumentNode(node);
    }

    private void enterDirectiveNode(DirectiveNode node) {
        log.debug("enterDirectiveNode {}", (Object)node);
        this.onEnterDirectiveNode(node);
    }

    private void exitDirectiveNode(DirectiveNode node) {
        log.debug("exitDirectiveNode {}", (Object)node);
        this.onExitDirectiveNode(node);
    }

    private void visitInternal(AstNode node) {
        log.debug("visitInternal {}", (Object)node);
        if (node instanceof CommandNode) {
            CommandNode n = (CommandNode)node;
            this.enterCommandNode(n);
            this.visitChildren(n);
            this.exitCommandNode(n);
        } else if (node instanceof OptionNode) {
            OptionNode n = (OptionNode)node;
            this.enterOptionNode(n);
            this.visitChildren(n);
            this.exitOptionNode(n);
        } else if (node instanceof CommandArgumentNode) {
            CommandArgumentNode n = (CommandArgumentNode)node;
            this.enterCommandArgumentNode(n);
            this.exitCommandArgumentNode(n);
        } else if (node instanceof OptionArgumentNode) {
            OptionArgumentNode n = (OptionArgumentNode)node;
            this.enterOptionArgumentNode(n);
            this.exitOptionArgumentNode(n);
        }
    }
}

