/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.parser;

import java.util.ArrayList;
import java.util.List;
import org.springframework.shell.command.parser.CommandArgumentNode;
import org.springframework.shell.command.parser.CommandNode;
import org.springframework.shell.command.parser.DirectiveNode;
import org.springframework.shell.command.parser.NonterminalAstNode;
import org.springframework.shell.command.parser.OptionArgumentNode;
import org.springframework.shell.command.parser.OptionNode;
import org.springframework.shell.command.parser.TerminalAstNode;
import org.springframework.shell.command.parser.Token;

public interface Ast {
    public AstResult generate(List<Token> var1);

    public static class DefaultAst
    implements Ast {
        @Override
        public AstResult generate(List<Token> tokens) {
            ArrayList<NonterminalAstNode> commandNodes = new ArrayList<NonterminalAstNode>();
            NonterminalAstNode commandNode = null;
            OptionNode optionNode = null;
            ArrayList<DirectiveNode> directiveNodes = new ArrayList<DirectiveNode>();
            for (Token token : tokens) {
                switch (token.getType()) {
                    case DIRECTIVE: {
                        String raw = token.getValue();
                        String[] split = raw.split(":", 2);
                        directiveNodes.add(new DirectiveNode(token, split[0], split.length > 1 ? split[1] : null));
                        break;
                    }
                    case COMMAND: {
                        CommandNode n = new CommandNode(token, token.getValue());
                        if (commandNode == null) {
                            commandNode = n;
                        } else {
                            commandNode.addChildNode(n);
                            commandNode = n;
                        }
                        commandNodes.add(commandNode);
                        break;
                    }
                    case OPTION: {
                        optionNode = new OptionNode(token, token.getValue());
                        commandNode.addChildNode(optionNode);
                        break;
                    }
                    case ARGUMENT: {
                        if (optionNode != null) {
                            OptionArgumentNode optionArgumentNode = new OptionArgumentNode(token, optionNode, token.getValue());
                            optionNode.addChildNode(optionArgumentNode);
                            break;
                        }
                        CommandArgumentNode commandArgumentNode = new CommandArgumentNode(token, (CommandNode)commandNode);
                        commandNode.addChildNode(commandArgumentNode);
                        break;
                    }
                    case DOUBLEDASH: {
                        optionNode = null;
                        break;
                    }
                }
            }
            ArrayList<NonterminalAstNode> nonterminalNodes = new ArrayList<NonterminalAstNode>();
            ArrayList<TerminalAstNode> terminalNodes = new ArrayList<TerminalAstNode>();
            if (commandNodes.size() > 0) {
                nonterminalNodes.add((NonterminalAstNode)commandNodes.get(0));
            }
            for (DirectiveNode dn : directiveNodes) {
                terminalNodes.add(dn);
            }
            return new AstResult(nonterminalNodes, terminalNodes);
        }
    }

    public record AstResult(List<NonterminalAstNode> nonterminalNodes, List<TerminalAstNode> terminalNodes) {
    }
}

