/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.parser.ParserConfig;
import org.springframework.shell.command.parser.Token;
import org.springframework.shell.command.parser.TokenType;

public class CommandModel {
    private final Map<String, CommandInfo> rootCommands = new HashMap<String, CommandInfo>();
    private final ParserConfig configuration;

    public CommandModel(Map<String, CommandRegistration> registrations, ParserConfig configuration) {
        this.configuration = configuration;
        this.buildModel(registrations);
    }

    @Nullable
    CommandInfo getRootCommand(String command) {
        return this.rootCommands.get(command);
    }

    CommandInfo resolve(List<String> commands) {
        CommandInfo info = null;
        boolean onRoot = true;
        for (String commandx : commands) {
            String command;
            String string = command = this.configuration.isEnabled(ParserConfig.Feature.CASE_SENSITIVE_COMMANDS) ? commandx : commandx.toLowerCase();
            if (onRoot) {
                info = this.rootCommands.get(command);
                onRoot = false;
                continue;
            }
            Optional<CommandInfo> nextInfo = info.getChildren().stream().filter(i -> i.command.equals(command)).findFirst();
            if (nextInfo.isEmpty()) break;
            info = nextInfo.get();
        }
        return info;
    }

    Map<String, CommandInfo> getRootCommands() {
        return this.rootCommands;
    }

    Map<String, Token> getValidRootTokens() {
        HashMap<String, Token> tokens = new HashMap<String, Token>();
        this.rootCommands.entrySet().forEach(e -> tokens.put((String)e.getKey(), new Token((String)e.getKey(), TokenType.COMMAND)));
        return tokens;
    }

    void xxx(String command, CommandRegistration registration) {
        String[] commands = command.split(" ");
        for (int i = 0; i < commands.length; ++i) {
        }
    }

    private CommandInfo getOrCreate(String[] commands, CommandRegistration registration) {
        CommandInfo ret = null;
        CommandInfo parent = null;
        int i = -1;
        for (String command : commands) {
            String key;
            String string = key = this.configuration.isEnabled(ParserConfig.Feature.CASE_SENSITIVE_COMMANDS) ? command : command.toLowerCase();
            if (++i == 0) {
                parent = this.rootCommands.get(command);
                if (parent == null) {
                    parent = new CommandInfo(key, i < commands.length - 1 ? null : registration, parent);
                    this.rootCommands.put(key, parent);
                }
                ret = parent;
                continue;
            }
            CommandInfo children = parent.getChildren(command);
            if (children == null) {
                children = new CommandInfo(key, i < commands.length - 1 ? null : registration, parent);
                parent.addChildred(command, children);
            }
            ret = parent = children;
        }
        if (ret.registration == null) {
            ret.registration = registration;
        }
        return ret;
    }

    private void buildModel(Map<String, CommandRegistration> registrations) {
        registrations.entrySet().forEach(e -> {
            String[] commands = ((String)e.getKey()).split(" ");
            this.getOrCreate(commands, (CommandRegistration)e.getValue());
        });
    }

    static class CommandInfo {
        String command;
        CommandRegistration registration;
        CommandInfo parent;
        private Map<String, CommandInfo> children = new HashMap<String, CommandInfo>();

        CommandInfo(String command, CommandRegistration registration, CommandInfo parent) {
            this.registration = registration;
            this.parent = parent;
            this.command = command;
        }

        Map<String, Token> getValidTokens() {
            HashMap<String, Token> tokens = new HashMap<String, Token>();
            this.children.values().forEach(commandInfo -> tokens.put(commandInfo.command, new Token(this.command, TokenType.COMMAND)));
            if (this.registration != null) {
                this.registration.getOptions().forEach(commandOption -> {
                    for (String longName : commandOption.getLongNames()) {
                        tokens.put("--" + longName, new Token(longName, TokenType.OPTION));
                    }
                    for (Character shortName : commandOption.getShortNames()) {
                        tokens.put("-" + (Character)shortName, new Token(shortName.toString(), TokenType.OPTION));
                    }
                });
            }
            return tokens;
        }

        public Collection<CommandInfo> getChildren() {
            return this.children.values();
        }

        public void addChildred(String command, CommandInfo children) {
            this.children.put(command, children);
        }

        CommandInfo getChildren(String command) {
            return this.children.get(command);
        }
    }
}

