/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.command.parser.CommandModel;
import org.springframework.shell.command.parser.MessageResult;
import org.springframework.shell.command.parser.ParserConfig;
import org.springframework.shell.command.parser.ParserMessage;
import org.springframework.shell.command.parser.Token;
import org.springframework.shell.command.parser.TokenType;

public interface Lexer {
    public LexerResult tokenize(List<String> var1);

    public static class DefaultLexer
    implements Lexer {
        private static final Logger log = LoggerFactory.getLogger(DefaultLexer.class);
        private final CommandModel commandModel;
        private final ParserConfig config;

        public DefaultLexer(CommandModel commandModel, ParserConfig config) {
            this.commandModel = commandModel;
            this.config = config;
        }

        private ArgumentsSplit splitArguments(List<String> arguments, Map<String, Token> validTokens) {
            int i = -1;
            boolean foundSplit = false;
            for (String argument : arguments) {
                if (!this.config.isEnabled(ParserConfig.Feature.CASE_SENSITIVE_COMMANDS)) {
                    argument = argument.toLowerCase();
                }
                ++i;
                if (!validTokens.containsKey(argument)) continue;
                foundSplit = true;
                break;
            }
            if (i < 0) {
                return new ArgumentsSplit(Collections.emptyList(), Collections.emptyList());
            }
            if (i == 0) {
                if (foundSplit) {
                    return new ArgumentsSplit(Collections.emptyList(), arguments);
                }
                return new ArgumentsSplit(arguments, Collections.emptyList());
            }
            return new ArgumentsSplit(arguments.subList(0, i), arguments.subList(i, arguments.size()));
        }

        private List<String> extractDirectives(List<String> arguments) {
            ArrayList<String> ret = new ArrayList<String>();
            Pattern pattern = Pattern.compile("\\[(.*?)\\]");
            String raw = arguments.stream().collect(Collectors.joining());
            Matcher matcher = pattern.matcher(raw);
            while (matcher.find()) {
                String group = matcher.group(1);
                ret.add(group);
            }
            return ret;
        }

        @Override
        public LexerResult tokenize(List<String> arguments) {
            log.debug("Tokenizing arguments {}", arguments);
            ArrayList<MessageResult> errorResults = new ArrayList<MessageResult>();
            ArrayList<Token> tokenList = new ArrayList<Token>();
            this.preValidate(errorResults, arguments);
            Map<String, Token> validTokens = this.commandModel.getValidRootTokens();
            ArgumentsSplit split = this.splitArguments(arguments, validTokens);
            List<String> beforeArguments = split.before();
            int i1 = split.before().size() - 1;
            if (this.config.isEnabled(ParserConfig.Feature.ALLOW_DIRECTIVES)) {
                List<String> rawDirectives = this.extractDirectives(beforeArguments);
                for (String raw : rawDirectives) {
                    tokenList.add(Token.of(raw, TokenType.DIRECTIVE, 0));
                }
            } else if (!this.config.isEnabled(ParserConfig.Feature.IGNORE_DIRECTIVES) && beforeArguments.size() > 0) {
                errorResults.add(MessageResult.of(ParserMessage.ILLEGAL_CONTENT_BEFORE_COMMANDS, 0, beforeArguments));
            }
            boolean foundDoubleDash = false;
            List<String> afterArguments = split.after();
            CommandModel.CommandInfo currentCommand = null;
            int i2 = i1;
            for (String argument : afterArguments) {
                ++i2;
                if (foundDoubleDash) {
                    tokenList.add(Token.of(argument, TokenType.ARGUMENT, i2));
                    continue;
                }
                if (!foundDoubleDash && "--".equals(argument)) {
                    tokenList.add(Token.of(argument, TokenType.DOUBLEDASH, i2));
                    foundDoubleDash = true;
                    continue;
                }
                String argumentToCheck = argument;
                if (!this.config.isEnabled(ParserConfig.Feature.CASE_SENSITIVE_COMMANDS) || !this.config.isEnabled(ParserConfig.Feature.CASE_SENSITIVE_OPTIONS)) {
                    argumentToCheck = argument.toLowerCase();
                }
                if (validTokens.containsKey(argumentToCheck)) {
                    Token token = validTokens.get(argumentToCheck);
                    switch (token.getType()) {
                        case COMMAND: {
                            currentCommand = currentCommand == null ? this.commandModel.getRootCommands().get(argumentToCheck) : currentCommand.getChildren(argument);
                            tokenList.add(Token.of(argument, TokenType.COMMAND, i2));
                            validTokens = currentCommand.getValidTokens();
                            break;
                        }
                        case OPTION: {
                            tokenList.add(Token.of(argument, TokenType.OPTION, i2));
                            break;
                        }
                    }
                    continue;
                }
                if (DefaultLexer.isLastTokenOfType(tokenList, TokenType.OPTION)) {
                    int decuceArgumentStyle = DefaultLexer.decuceArgumentStyle(argument);
                    if (decuceArgumentStyle > 0) {
                        tokenList.add(Token.of(argument, TokenType.OPTION, i2));
                        continue;
                    }
                    if (decuceArgumentStyle < 0) {
                        tokenList.add(Token.of(argument, TokenType.ARGUMENT, i2));
                        continue;
                    }
                    tokenList.add(Token.of(argument, TokenType.OPTION, i2));
                    continue;
                }
                if (DefaultLexer.isLastTokenOfType(tokenList, TokenType.COMMAND)) {
                    if (argument.startsWith("-")) {
                        tokenList.add(Token.of(argument, TokenType.OPTION, i2));
                        continue;
                    }
                    tokenList.add(Token.of(argument, TokenType.ARGUMENT, i2));
                    continue;
                }
                if (!DefaultLexer.isLastTokenOfType(tokenList, TokenType.ARGUMENT)) continue;
                int decuceArgumentStyle = DefaultLexer.decuceArgumentStyle(argument);
                if (decuceArgumentStyle < 0) {
                    tokenList.add(Token.of(argument, TokenType.ARGUMENT, i2));
                    continue;
                }
                tokenList.add(Token.of(argument, TokenType.OPTION, i2));
            }
            log.debug("Generated token list {}", tokenList);
            return new LexerResult(tokenList, errorResults);
        }

        private void preValidate(List<MessageResult> errorResults, List<String> arguments) {
            String arg;
            if (arguments.size() > 0 && "--".equals(arg = arguments.get(0))) {
                errorResults.add(MessageResult.of(ParserMessage.ILLEGAL_CONTENT_BEFORE_COMMANDS, 0, arg));
            }
        }

        private static boolean isLastTokenOfType(List<Token> tokenList, TokenType type) {
            return tokenList.size() > 0 && tokenList.get(tokenList.size() - 1).getType() == type;
        }

        private static int decuceArgumentStyle(String str) {
            if (str.length() < 2) {
                return -1;
            }
            if (str.charAt(0) != '-') {
                return -1;
            }
            if (str.length() > 1 && str.charAt(0) == '-' && str.charAt(1) == '-') {
                return 0;
            }
            int ret = 1;
            for (int i = 1; i < str.length(); ++i) {
                if (Character.isLetter(str.charAt(i))) continue;
                ret = -1;
                break;
            }
            return ret;
        }

        private record ArgumentsSplit(List<String> before, List<String> after) {
        }
    }

    public record LexerResult(List<Token> tokens, List<MessageResult> messageResults) {
    }
}

