/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.shell.command.CommandOption;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.parser.AbstractNodeVisitor;
import org.springframework.shell.command.parser.Ast;
import org.springframework.shell.command.parser.CommandArgumentNode;
import org.springframework.shell.command.parser.CommandModel;
import org.springframework.shell.command.parser.CommandNode;
import org.springframework.shell.command.parser.DirectiveNode;
import org.springframework.shell.command.parser.DirectiveResult;
import org.springframework.shell.command.parser.Lexer;
import org.springframework.shell.command.parser.MessageResult;
import org.springframework.shell.command.parser.OptionArgumentNode;
import org.springframework.shell.command.parser.OptionNode;
import org.springframework.shell.command.parser.ParserConfig;
import org.springframework.shell.command.parser.ParserMessage;
import org.springframework.shell.command.parser.Token;
import org.springframework.util.StringUtils;

public interface Parser {
    public ParseResult parse(List<String> var1);

    public static class DefaultNodeVisitor
    extends AbstractNodeVisitor {
        private final CommandModel commandModel;
        private final ConversionService conversionService;
        private final ParserConfig config;
        private final List<MessageResult> commonMessageResults = new ArrayList<MessageResult>();
        private List<String> resolvedCommmand = new ArrayList<String>();
        private List<ParseResult.OptionResult> optionResults = new ArrayList<ParseResult.OptionResult>();
        private List<String> currentOptionArgument = new ArrayList<String>();
        private List<DirectiveResult> directiveResults = new ArrayList<DirectiveResult>();
        private List<OptionNode> invalidOptionNodes = new ArrayList<OptionNode>();
        private List<ParseResult.ArgumentResult> argumentResults = new ArrayList<ParseResult.ArgumentResult>();
        private int commandArgumentPos = 0;
        private int optionPos = -1;
        private long expectedOptionCount;
        private List<CommandOption> currentOptions = new ArrayList<CommandOption>();

        DefaultNodeVisitor(CommandModel commandModel, ConversionService conversionService, ParserConfig config) {
            this.commandModel = commandModel;
            this.conversionService = conversionService;
            this.config = config;
        }

        @Override
        protected ParseResult buildResult() {
            CommandModel.CommandInfo info = this.commandModel.resolve(this.resolvedCommmand);
            CommandRegistration registration = info != null ? info.registration : null;
            ArrayList<MessageResult> messageResults = new ArrayList<MessageResult>();
            if (registration != null) {
                messageResults.addAll(this.commonMessageResults);
                messageResults.addAll(this.validateOptionIsValid(registration));
                Set resolvedOptions = this.optionResults.stream().map(or -> or.option()).collect(Collectors.toSet());
                List optionsForArguments = registration.getOptions().stream().filter(o -> !resolvedOptions.contains(o)).filter(o -> o.getPosition() > -1).sorted(Comparator.comparingInt(o -> o.getPosition())).collect(Collectors.toList());
                List argumentValues = this.argumentResults.stream().sorted(Comparator.comparingInt(ar -> ar.position())).map(ar -> ar.value()).collect(Collectors.toList());
                int i = 0;
                for (CommandOption o2 : optionsForArguments) {
                    int aMax = o2.getArityMax();
                    if (aMax < 0) {
                        aMax = optionsForArguments.size() == 1 ? Integer.MAX_VALUE : 1;
                    }
                    int j = i + aMax;
                    j = Math.min(argumentValues.size(), j);
                    List asdf = argumentValues.subList(i, j);
                    if (asdf.isEmpty()) {
                        if (o2.getDefaultValue() == null) {
                            resolvedOptions.add(o2);
                            this.optionResults.add(ParseResult.OptionResult.of(o2, null));
                        }
                    } else {
                        List toConvertValue = asdf.size() == 1 ? asdf.get(0) : asdf;
                        Object value = this.convertOptionType(o2, toConvertValue);
                        resolvedOptions.add(o2);
                        this.optionResults.add(ParseResult.OptionResult.of(o2, value));
                    }
                    if (j == argumentValues.size()) break;
                    i = j;
                }
                registration.getOptions().stream().filter(o -> o.getDefaultValue() != null).filter(o -> !resolvedOptions.contains(o)).forEach(o -> {
                    resolvedOptions.add(o);
                    Object value = this.convertOptionType((CommandOption)o, o.getDefaultValue());
                    this.optionResults.add(ParseResult.OptionResult.of(o, value));
                });
                messageResults.addAll(this.validateOptionNotMissing(registration));
            }
            return new ParseResult(registration, this.optionResults, this.argumentResults, messageResults, this.directiveResults);
        }

        @Override
        protected void onEnterDirectiveNode(DirectiveNode node) {
            this.directiveResults.add(DirectiveResult.of(node.getName(), node.getValue()));
        }

        @Override
        protected void onExitDirectiveNode(DirectiveNode node) {
        }

        @Override
        protected void onEnterRootCommandNode(CommandNode node) {
            this.expectedOptionCount = DefaultNodeVisitor.optionCountInCommand(node);
            this.resolvedCommmand.add(node.getCommand());
        }

        @Override
        protected void onExitRootCommandNode(CommandNode node) {
        }

        @Override
        protected void onEnterCommandNode(CommandNode node) {
            this.expectedOptionCount = DefaultNodeVisitor.optionCountInCommand(node);
            this.resolvedCommmand.add(node.getCommand());
        }

        @Override
        protected void onExitCommandNode(CommandNode node) {
        }

        @Override
        protected void onEnterOptionNode(OptionNode node) {
            ++this.optionPos;
            this.commandArgumentPos = 0;
            this.currentOptions.clear();
            this.currentOptionArgument.clear();
            CommandModel.CommandInfo info = this.commandModel.resolve(this.resolvedCommmand);
            String name = node.getName();
            if (name.startsWith("--")) {
                info.registration.getOptions().forEach(option -> {
                    String nameToMatch;
                    Set longNames = Arrays.asList(option.getLongNames()).stream().map(n -> "--" + n).collect(Collectors.toSet());
                    boolean match = longNames.contains(nameToMatch = this.config.isEnabled(ParserConfig.Feature.CASE_SENSITIVE_OPTIONS) ? name : name.toLowerCase());
                    if (match) {
                        this.currentOptions.add((CommandOption)option);
                    }
                });
            } else if (name.startsWith("-")) {
                if (name.length() == 2) {
                    info.registration.getOptions().forEach(option -> {
                        Set shortNames = Arrays.asList(option.getShortNames()).stream().map(n -> "-" + Character.toString(n.charValue())).collect(Collectors.toSet());
                        boolean match = shortNames.contains(name);
                        if (match) {
                            this.currentOptions.add((CommandOption)option);
                        }
                    });
                } else if (name.length() > 2) {
                    info.registration.getOptions().forEach(option -> {
                        Set shortNames = Arrays.asList(option.getShortNames()).stream().map(n -> "-" + Character.toString(n.charValue())).collect(Collectors.toSet());
                        for (int i = 1; i < name.length(); ++i) {
                            boolean match = shortNames.contains("-" + name.charAt(i));
                            if (!match) continue;
                            this.currentOptions.add((CommandOption)option);
                        }
                    });
                }
            }
        }

        @Override
        protected void onExitOptionNode(OptionNode node) {
            if (!this.currentOptions.isEmpty()) {
                for (CommandOption currentOption : this.currentOptions) {
                    int max = currentOption.getArityMax() > 0 ? currentOption.getArityMax() : Integer.MAX_VALUE;
                    max = Math.min(max, this.currentOptionArgument.size());
                    List<String> toUse = this.currentOptionArgument.subList(0, max);
                    List<String> toUnused = this.currentOptionArgument.subList(max, this.currentOptionArgument.size());
                    toUnused.forEach(a -> this.argumentResults.add(ParseResult.ArgumentResult.of(a, this.commandArgumentPos++)));
                    if ((long)(this.optionPos + 1) < this.expectedOptionCount) {
                        if (currentOption.getArityMin() > -1 && this.currentOptionArgument.size() < currentOption.getArityMin()) {
                            arg = currentOption.getLongNames()[0];
                            this.commonMessageResults.add(MessageResult.of(ParserMessage.NOT_ENOUGH_OPTION_ARGUMENTS, 0, arg, this.currentOptionArgument.size()));
                        } else if (currentOption.getArityMax() > -1 && this.currentOptionArgument.size() > currentOption.getArityMax()) {
                            arg = currentOption.getLongNames()[0];
                            this.commonMessageResults.add(MessageResult.of(ParserMessage.TOO_MANY_OPTION_ARGUMENTS, 0, arg, currentOption.getArityMax()));
                        }
                    } else if (currentOption.getArityMin() > -1 && toUse.size() < currentOption.getArityMin()) {
                        arg = currentOption.getLongNames()[0];
                        this.commonMessageResults.add(MessageResult.of(ParserMessage.NOT_ENOUGH_OPTION_ARGUMENTS, 0, arg, currentOption.getArityMin()));
                    } else if (currentOption.getArityMax() > -1 && toUse.size() > currentOption.getArityMax()) {
                        arg = currentOption.getLongNames()[0];
                        this.commonMessageResults.add(MessageResult.of(ParserMessage.TOO_MANY_OPTION_ARGUMENTS, 0, arg, currentOption.getArityMax()));
                    }
                    Object value = null;
                    if (toUse.size() == 1) {
                        value = toUse.get(0);
                    } else if (toUse.size() > 1) {
                        value = new ArrayList<String>(toUse);
                    }
                    try {
                        value = this.convertOptionType(currentOption, value);
                    }
                    catch (Exception e) {
                        this.commonMessageResults.add(MessageResult.of(ParserMessage.ILLEGAL_OPTION_VALUE, 0, value, e.getMessage()));
                    }
                    this.optionResults.add(new ParseResult.OptionResult(currentOption, value));
                }
            } else {
                this.invalidOptionNodes.add(node);
            }
        }

        @Override
        protected void onEnterCommandArgumentNode(CommandArgumentNode node) {
            this.argumentResults.add(ParseResult.ArgumentResult.of(node.getToken().getValue(), this.commandArgumentPos++));
        }

        @Override
        protected void onExitCommandArgumentNode(CommandArgumentNode node) {
        }

        @Override
        protected void onEnterOptionArgumentNode(OptionArgumentNode node) {
            this.currentOptionArgument.add(node.getValue());
        }

        @Override
        protected void onExitOptionArgumentNode(OptionArgumentNode node) {
        }

        private Object convertOptionType(CommandOption option, Object value) {
            TypeDescriptor targetType;
            Object source;
            TypeDescriptor sourceType;
            ResolvableType type = option.getType();
            if (value == null && type != null && type.isAssignableFrom(Boolean.TYPE)) {
                return true;
            }
            if (this.conversionService != null && option.getType() != null && value != null && this.conversionService.canConvert(sourceType = new TypeDescriptor(ResolvableType.forClass((source = value).getClass()), null, null), targetType = new TypeDescriptor(option.getType(), null, null))) {
                value = this.conversionService.convert(source, sourceType, targetType);
            }
            return value;
        }

        private List<MessageResult> validateOptionNotMissing(CommandRegistration registration) {
            HashSet requiredOptions = registration.getOptions().stream().filter(o -> o.isRequired()).collect(Collectors.toCollection(() -> new HashSet()));
            List argumentResultValues = this.argumentResults.stream().map(ar -> ar.value).collect(Collectors.toList());
            this.optionResults.stream().filter(or -> or.value() != null).map(or -> or.option()).forEach(o -> requiredOptions.remove(o));
            Set requiredOptions2 = requiredOptions.stream().filter(o -> {
                if (argumentResultValues.isEmpty()) {
                    return true;
                }
                List<String> longNames = Arrays.asList(o.getLongNames());
                return !Collections.disjoint(argumentResultValues, longNames);
            }).collect(Collectors.toSet());
            return requiredOptions2.stream().map(o -> {
                Object ins0 = "";
                if (o.getLongNames().length > 0) {
                    ins0 = "--" + o.getLongNames()[0];
                } else if (o.getShortNames().length > 0) {
                    ins0 = "-" + o.getShortNames()[0];
                }
                Object ins1 = "";
                if (StringUtils.hasText((String)o.getDescription())) {
                    ins1 = ", " + o.getDescription();
                }
                return MessageResult.of(ParserMessage.MANDATORY_OPTION_MISSING, 0, ins0, ins1);
            }).collect(Collectors.toList());
        }

        private List<MessageResult> validateOptionIsValid(CommandRegistration registration) {
            return this.invalidOptionNodes.stream().map(on -> MessageResult.of(ParserMessage.UNRECOGNISED_OPTION, 0, on.getName())).collect(Collectors.toList());
        }

        private static long optionCountInCommand(CommandNode node) {
            if (node == null) {
                return 0L;
            }
            return node.getChildren().stream().filter(n -> n instanceof OptionNode).count();
        }
    }

    public static class DefaultParser
    implements Parser {
        private final ParserConfig config;
        private final CommandModel commandModel;
        private final Lexer lexer;
        private final Ast ast;
        private ConversionService conversionService;

        public DefaultParser(CommandModel commandModel, Lexer lexer, Ast ast) {
            this(commandModel, lexer, ast, new ParserConfig());
        }

        public DefaultParser(CommandModel commandModel, Lexer lexer, Ast ast, ParserConfig config) {
            this(commandModel, lexer, ast, config, null);
        }

        public DefaultParser(CommandModel commandModel, Lexer lexer, Ast ast, ParserConfig config, ConversionService conversionService) {
            this.commandModel = commandModel;
            this.lexer = lexer;
            this.ast = ast;
            this.config = config;
            this.conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        }

        @Override
        public ParseResult parse(List<String> arguments) {
            Lexer.LexerResult lexerResult = this.lexer.tokenize(arguments);
            List<Token> tokens = lexerResult.tokens();
            Ast.AstResult astResult = this.ast.generate(tokens);
            DefaultNodeVisitor visitor = new DefaultNodeVisitor(this.commandModel, this.conversionService, this.config);
            ParseResult parseResult = visitor.visit(astResult.nonterminalNodes(), astResult.terminalNodes());
            parseResult.messageResults().addAll(lexerResult.messageResults());
            return parseResult;
        }
    }

    public record ParseResult(CommandRegistration commandRegistration, List<OptionResult> optionResults, List<ArgumentResult> argumentResults, List<MessageResult> messageResults, List<DirectiveResult> directiveResults) {

        public record ArgumentResult(String value, int position) {
            public static ArgumentResult of(String value, int position) {
                return new ArgumentResult(value, position);
            }
        }

        public record OptionResult(CommandOption option, Object value) {
            public static OptionResult of(CommandOption option, Object value) {
                return new OptionResult(option, value);
            }
        }
    }
}

