/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.parser;

public class ParserConfig {
    private long features = Feature.collectDefaults();

    boolean isEnabled(Feature feature) {
        return (this.features & feature.getMask()) != 0L;
    }

    ParserConfig configure(Feature feature, boolean state) {
        return state ? this.enable(feature) : this.disable(feature);
    }

    ParserConfig enable(Feature feature) {
        this.features |= feature.getMask();
        return this;
    }

    ParserConfig disable(Feature feature) {
        this.features &= feature.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    public static enum Feature {
        ALLOW_DIRECTIVES(false),
        IGNORE_DIRECTIVES(false),
        CASE_SENSITIVE_COMMANDS(true),
        CASE_SENSITIVE_OPTIONS(true);

        private final boolean defaultState;
        private final long mask = 1 << this.ordinal();

        private Feature(boolean defaultState) {
            this.defaultState = defaultState;
        }

        public static long collectDefaults() {
            long flags = 0L;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        public boolean enabledByDefault() {
            return this.defaultState;
        }

        public boolean enabledIn(int flags) {
            return ((long)flags & this.mask) != 0L;
        }

        public long getMask() {
            return this.mask;
        }
    }
}

