/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.parser;

import java.text.MessageFormat;

public enum ParserMessage {
    ILLEGAL_CONTENT_BEFORE_COMMANDS(Type.ERROR, 1000, "Illegal content before commands ''{0}''"),
    MANDATORY_OPTION_MISSING(Type.ERROR, 2000, "Missing mandatory option ''{0}''{1}"),
    UNRECOGNISED_OPTION(Type.ERROR, 2001, "Unrecognised option ''{0}''"),
    ILLEGAL_OPTION_VALUE(Type.ERROR, 2002, "Illegal option value ''{0}'', reason ''{1}''"),
    NOT_ENOUGH_OPTION_ARGUMENTS(Type.ERROR, 2003, "Not enough arguments for option ''{0}'', requires at least ''{1}''"),
    TOO_MANY_OPTION_ARGUMENTS(Type.ERROR, 2004, "Too many arguments for option ''{0}'', requires at most ''{1}''");

    private Type type;
    private int code;
    private String message;

    private ParserMessage(Type type, int code, String message) {
        this.type = type;
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public Type getType() {
        return this.type;
    }

    public String formatMessage(Object ... inserts) {
        return this.formatMessage(false, -1, inserts);
    }

    public String formatMessage(boolean useCode, int position, Object ... inserts) {
        StringBuilder msg = new StringBuilder();
        if (useCode) {
            msg.append(this.code);
            switch (this.type) {
                case WARNING: {
                    msg.append("W");
                    break;
                }
                case ERROR: {
                    msg.append("E");
                }
            }
            msg.append(":");
        }
        if (position != -1) {
            msg.append("(pos ").append(position).append("): ");
        }
        msg.append(MessageFormat.format(this.message, inserts));
        return msg.toString();
    }

    public static enum Type {
        WARNING,
        ERROR;

    }
}

