/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class OptionNameModifierSupport {
    public static final CommandRegistration.OptionNameModifier NOOP = name -> name;
    public static final CommandRegistration.OptionNameModifier CAMELCASE = name -> OptionNameModifierSupport.toCamelCase(name);
    public static final CommandRegistration.OptionNameModifier SNAKECASE = name -> OptionNameModifierSupport.toSnakeCase(name);
    public static final CommandRegistration.OptionNameModifier KEBABCASE = name -> OptionNameModifierSupport.toKebabCase(name);
    public static final CommandRegistration.OptionNameModifier PASCALCASE = name -> OptionNameModifierSupport.toPascalCase(name);
    private static final Pattern PATTERN = Pattern.compile("[A-Z]{2,}(?=[A-Z][a-z]+[0-9]*|\b)|[A-Z]?[a-z]+[0-9]*|[A-Z]|[0-9]+");

    public static String toCamelCase(String name) {
        return OptionNameModifierSupport.toCapitalizeCase(name, false, ' ', '-', '_');
    }

    public static String toSnakeCase(String name) {
        return OptionNameModifierSupport.matchJoin(name, "_");
    }

    public static String toKebabCase(String name) {
        return OptionNameModifierSupport.matchJoin(name, "-");
    }

    public static String toPascalCase(String name) {
        return OptionNameModifierSupport.toCapitalizeCase(name, true, ' ', '-', '_');
    }

    private static String matchJoin(String name, String delimiter) {
        Matcher matcher = PATTERN.matcher(name);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group();
            matches.add(group);
        }
        return matches.stream().map(x -> x.toLowerCase()).collect(Collectors.joining(delimiter));
    }

    private static String toCapitalizeCase(String name, boolean capitalizeFirstLetter, char ... delimiters) {
        if (!StringUtils.hasText((String)name)) {
            return name;
        }
        String nameL = name.toLowerCase();
        int strLen = nameL.length();
        int[] newCodePoints = new int[strLen];
        Set<Integer> delimiterSet = OptionNameModifierSupport.toDelimiterSet(delimiters);
        int outOffset = 0;
        boolean capitalizeNext = capitalizeFirstLetter;
        boolean delimiterFound = false;
        int index = 0;
        while (index < strLen) {
            int codePoint = nameL.codePointAt(index);
            if (delimiterSet.contains(codePoint)) {
                capitalizeNext = outOffset != 0;
                index += Character.charCount(codePoint);
                delimiterFound = true;
                continue;
            }
            if (capitalizeNext || outOffset == 0 && capitalizeFirstLetter) {
                int titleCaseCodePoint = Character.toTitleCase(codePoint);
                newCodePoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
                continue;
            }
            newCodePoints[outOffset++] = codePoint;
            index += Character.charCount(codePoint);
        }
        if (!delimiterFound) {
            if (capitalizeFirstLetter) {
                return name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
            }
            return name.substring(0, 1).toLowerCase() + name.substring(1, name.length());
        }
        return new String(newCodePoints, 0, outOffset);
    }

    private static Set<Integer> toDelimiterSet(char[] delimiters) {
        HashSet<Integer> delimiterHashSet = new HashSet<Integer>();
        delimiterHashSet.add(Character.codePointAt(new char[]{' '}, 0));
        if (ObjectUtils.isEmpty((Object)delimiters)) {
            return delimiterHashSet;
        }
        for (int index = 0; index < delimiters.length; ++index) {
            delimiterHashSet.add(Character.codePointAt(delimiters, index));
        }
        return delimiterHashSet;
    }
}

